/*
* @author SAP
* @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDBoundValueSet.java#1 $
* 
*/package com.sap.tc.webdynpro.progmodel.api;

import java.util.Locale;
import java.util.Map;

/**
 * IWDBoundValueSet is a utility class that can bind a DropDownByKey UI element 
 * to a context node.
 * @SAPWebDynproPart 2
 */
public interface IWDBoundValueSet extends IWDOnDemandValueSetService {
  
  /**
   * Optional interface in case the application needs to implement a filter function
   * for large valuesets used in an evs component. 
   * @SAPWebDynproPart 1
   */
  public interface IWDFilterListener extends IWDValueSetSource{
  	/**
  	 * Fill context node <code>valueSetNode</code> using <code>filter</code> as search criteria
  	 * 
  	 * @param valueSetNode is the node to be filled
		 * @param locale for the display text (may be null)
  	 * @param is the filter object, containing a single string 
  	 */
  	public void fillNode(IWDNode valueSetNode, IWDValueFilter filter, Locale locale);
  	
  }
  
}
