/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDAttributeInfo.java#3 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.dictionary.runtime.IDataType;
import com.sap.dictionary.runtime.ISimpleType;
import com.sap.dictionary.runtime.ISimpleTypeModifiable;

/**
 * Structure information for a context attribute.
 * <p>
 * The information contained herein either has been declared at design time
 * (for a statically declared attribute) or has been provided at runtime
 * (dynamically declared attribute). 
 * <p>
 * Methods in {@link IWDNodeInfo} can be used to {@link IWDNodeInfo#getAttribute(String) retrieve}
 * or {@link IWDNodeInfo#addAttribute(String,String) dynamically create} instances
 * of this interface.
 * <p>
 * DO NOT EXTEND THIS TYPE. It won't work.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDAttributeInfo.java#3 $
 */
public interface IWDAttributeInfo
{
  /**
   * Returns the name of the attribute. The name is unique in the context of the
   * containing IWDNodeInfo and can be used to retrieve/set the value of the
   * corresponding attribute.
   * @return the name of the attribute
   */
  String getName();

  /**
   * Returns the node info, this attribute belongs to.
   * @return the node info this attribute belongs to
   */
  IWDNodeInfo getNode();

  /**
   * Returns the origin's name which is the name of the attribute either in the 
   * origin node or in the model object. Returns <code>null</code> for unmapped
   * value nodes.
   * @return the origin's name
   */
  public String getOriginName();

  /**
   * Returns the data type of the attribute. The attribute is guaranteed to have
   * one. Nevertheless under special circumstances this method returns
   * <code>null</code>: If you map into a component that you create manually 
   * and that component has not been created yet. In this case the attribute
   * does not yet know the type and returns <code>null</code>.
   * @return the data type of the attribute.
   */
  IDataType getDataType();

  /**
   * Returns whether the attribute contains an ISimpleType. Otherwise it's a 
   * JavaType. Only attributes based on ISimpleType can be rendered to the GUI.
   * @return <code>true</code>, if the attribute contains an ISimpleType.
   */
  boolean hasSimpleType();

  /**
   * Returns the data type of the attribute.
   * @return the data type of the attribute.
   * @throws ContextException if the IWDAttributeInfo does not contain an
   *    ISimpleType, but another IDataType.
   * @see #getDataType()
   */
  ISimpleType getSimpleType();

  /**
   * Returns a modifiable version of the data type of the attribute.
   * The modifiable type is cloned from the standard type upon first access
   * and is used for this attribute only. Once created, alyways the same instance
   * will be returned for this attribute as long as the context exists.
   * <p>
   * A modifiable data type can only be queried from a non-mapped attribute. A
   * mapped attribute throws a ContextException. The reason for this is that
   * you always should be aware of the effects of changing the attribute type.
   * This change affects the complete mapping chain, even across component
   * boundaries. So you are only allowed to modify the data source.
   *
   * @return a modifiable version of the attributes data type
   * @throws ContextException if the IWDAttributeInfo does not contain an
   *    ISimpleType, but another IDataType or if the attribute is mapped.
   */
  ISimpleTypeModifiable getModifiableSimpleType();

  /**
   * Returns the AttributeInfo of the attribute this attribute is mapped to or
   * <code>null</code> if this attribute is unmapped.
   *
   * @return the AttributeInfo of the attribute this is mapped to
   */
  IWDAttributeInfo getDataAttribute();

  /**
   * Checks whether this attribute is read only for clients.
   * <p>
   * Note: if an attribute is read-only for clients, it might or might not
   * be writable for applications. Normally all attributes are writable for
   * applications, but if a context attribute is mapped to a model class property
   * and if that model class property is read-only or if the attribute is
   * calculated and no setter is declared, then the attribute is read-only
   * for applications, too.
   *
   * @return read only state of attribute
   */
  boolean isReadOnly();

  /**
   * Returns whether this attribute has been declared at design time. There are
   * several possibilities that a node may have undeclared attributes.
   * <ul>
   *   <li>Attributes may have been added dynamically.
   *   <li>The node may be based on a dictionary structure. In that case all
   *     structure fields are automatically added to the node as attributes.
   * </ul>
   * @return whether the attribute is declared at design time
   */
  boolean isDeclared();

  /**
   * Set a special formatting service for currencies when working with an R/3
   * system. R/3 has a very special handling of currencies and some RFCs do not
   * normalize this. In that case the attribute in Web Dynpro must also store
   * the value denormalized and pass it to the R/3 system this way.
   * <p>
   * If you are not working with Adaptive RFC or if you are only usings BAPIs,
   * you will not need this method. See the documentation of the Java Dictionary
   * for more details.
   */
  void setR3NormalizingFormattingService(boolean formatting);
}
