/*
 * @(#) $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDApplication.java#1 $
 *
 * Copyright(c) 2003, SAP AG, All Rights Reserved.
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.webdynpro.progmodel.repository.IWDApplicationInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;

/**
 * Generic API of a Web Dynpro Application.
 * All applications created by the Web Dynpro toolset implement this interface.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDApplication.java#1 $
 */
public interface IWDApplication {

  /**
   * Returns the name of the application.
   * @return the name of the application
   */
  public String getName();

  /**
   * Returns the metadata describing this application.
   * @return the application metadata object 
   */
  public IWDApplicationInfo getApplicationInfo();

  /**
   * Returns the deployable object part of this application.
   * @return the deployable object part of this application
   */
  public WDDeployableObjectPart getDeployableObjectPart();
}
