/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/WDModelScopeType.java#2 $
 */
package com.sap.tc.webdynpro.progmodel.model.api;

import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.ScopeType;

/**
 * This interface defines the scopes available for Web Dynpro models.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/WDModelScopeType.java#2 $
 */
public class WDModelScopeType
{
	private ScopeType scopeType;

	private WDModelScopeType(ScopeType scopeType)
	{
		this.scopeType = scopeType;
	}

	public String toString()
	{
		return scopeType.toString();
	}

	protected ScopeType getScopeType()
	{
		return scopeType;
	}

	protected static WDModelScopeType getModelScopeType(ScopeType scopeType)
	{
		if (scopeType == IScope.APPLICATION_SCOPE)                         return APPLICATION_SCOPE;
		else if (scopeType == IScope.TASK_SCOPE)                           return TASK_SCOPE;
		else if (scopeType == IScope.VM_SCOPE)                             return VM_SCOPE;
		else if (scopeType == IScope.COMPONENT_SCOPE)                      return COMPONENT_SCOPE;
		else if (scopeType == IScope.SERVERSESSION_SCOPE)                  return SERVERSESSION_SCOPE;
		else if (scopeType == IScope.SERVERSESSION_AT_LEAST_ONE_APP_SCOPE) return SERVERSESSION_AT_LEAST_ONE_APP_SCOPE;
		else                                                               return NO_SCOPE;
	}
	/**
	 * Scope Component.
	 */
	static public final WDModelScopeType COMPONENT_SCOPE =	                    new WDModelScopeType(IScope.COMPONENT_SCOPE);

	/**
	 * Scope Application.
	 */
	static public final WDModelScopeType APPLICATION_SCOPE =	                  new WDModelScopeType(IScope.APPLICATION_SCOPE);

	/**
	 * Scope VM.
   * @deprecated DO NOT USE! This constant may be withdrawn from the public 
   *   Web Dynpro API with the first new NetWeaver release in 2006 because 
   *   the behaviour can not be guaranteed.
	 */
	static public final WDModelScopeType VM_SCOPE =	                            new WDModelScopeType(IScope.VM_SCOPE);

	/**
	 * Task Scope => scope lives during a single request/response cycle
	 */
	static public final WDModelScopeType TASK_SCOPE =	                          new WDModelScopeType(IScope.TASK_SCOPE);

	/**
	 * No Scope.
	 */
	static public final WDModelScopeType NO_SCOPE =	                            new WDModelScopeType(IScope.NO_SCOPE);

	/**
	 * Server Session Scope.
   * @deprecated DO NOT USE! This constant may be withdrawn from the public 
   *   Web Dynpro API with the first new NetWeaver release in 2006 because 
   *   the behaviour can not be guaranteed.
	 */
	static public final WDModelScopeType SERVERSESSION_SCOPE =	                new WDModelScopeType(IScope.SERVERSESSION_SCOPE);

	/**
	 * Server Session Scope as long as at least one application exists.
   * @deprecated DO NOT USE! This constant may be withdrawn from the public 
   *   Web Dynpro API with the first new NetWeaver release in 2006 because 
   *   the behaviour can not be guaranteed.
	 */
	static public final WDModelScopeType SERVERSESSION_AT_LEAST_ONE_APP_SCOPE =	new WDModelScopeType(IScope.SERVERSESSION_AT_LEAST_ONE_APP_SCOPE);

}
