/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelClassChangeTracking.java#2 $
 */
package com.sap.tc.webdynpro.progmodel.model.api;


/**
 * Model Classes implementing this interface are capable of tracking changes.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelClassChangeTracking.java#2 $
 */
public interface IWDModelClassChangeTracking
{

	/**
	 * marks an attribute changed
	 * @param attributeName The name of the changed attribute or <code>null</code>
	 * to mark all attributes as changed
	 */
	public void markAttributeChanged(String attributeName);

	/**
	 * marks an attribute unchanged
	 * @param attributeName The name of the changed attribute or <code>null</code>
	 * to mark all attributes as unchanged
	 */
	public void markAttributeUnChanged(String attributeName);

	/**
	 * Returns whether the attribute specified by the attributeName has been changed.
	 * @param attributeName The name of the attribute to check if it has been changed
	 */
	public boolean isAttributeChanged(String attributeName);

	/**
	 * marks a role changed
	 * @param roleName The name of the changed role or <code>null</code>
	 * to mark all roles as changed
	 */
	public void markRoleChanged(String roleName);

	/**
	 * marks a role unchanged
	 * @param roleName The name of the role to unchange or <code>null</code>
	 * to mark all roles as unchanged
	 */
	public void markRoleUnChanged(String roleName);

	/**
	 * Returns whether the role specified by the roleName has been changed.
	 * @param roleName The name of the role to check if it has been changed
	 */
	public boolean isRoleChanged(String roleName);

	/**
	 * Resets the change flags
	 */
	public void resetChanged();

///////////////////////////////////////////////////////////////////////////////////
///
///       The following methods are DEPRECATED!!
///
///////////////////////////////////////////////////////////////////////////////////

  /**
   * marks an attribute changed
   * @param attributeIndex The index of the changed attribute or <code>-1</code>
   *                        to mark all attributes changed
   *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter. 
   *   Therefore use the String based method {@link #markAttributeChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public void setAttributeChanged(int index);

  /**
   * marks an attribute unchanged
   * @param attributeIndex The index of the attribute to back to unchanged or <code>-1</code>
   *                        to mark all attributes un changed
   *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter.
   *   Therefore use the String based method {@link #markAttributeUnChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public void setAttributeUnChanged(int index);

  /**
   * Returns whether the attribute specified by the index has been changed.
	 *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter.
   *   Therefore use the String based method {@link #isAttributeChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public boolean isAttributeChanged(int index);

  /**
   * marks a role changed
   * @param index The index of the changed role or <code>-1</code>
   *                        to mark all roles changed
   *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter.
   *   Therefore use the String based method {@link #markRoleChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public void setRoleChanged(int index);

  /**
   * marks a role unchanged
   * @param index The index of the role to set back to unchanged or <code>-1</code>
   *                        to mark all roles unchanged
   *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter.
   *   Therefore use the String based method {@link #markRoleUnChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public void setRoleUnChanged(int index);

  /**
   * Returns whether the role specified by the index has been changed.
   *
   * @deprecated Indexes may not be stable over time in the DynamicRFCAdapter.
   *   Therefore use the String based method {@link #isRoleChanged(String)} 
   *   instead. The index based method may be withdrawn with the first new 
   *   NetWeaver release in 2006.
   */
  public boolean isRoleChanged(int index);

}
