/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModel.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.model.api;

import com.sap.tc.cmi.model.ICMIModel;

/**
 * WebDynpro specific subinterface of CMIModel that knows about model scopes and model instance IDs.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModel.java#1 $
 */

public interface IWDModel extends ICMIModel
{
   /**
    * Gets the scope in which this model is managed
    * which defines the maximum lifespan of this model instance
    *
    * e.g. returning WDModelScopeType.APPLICATION_SCOPE
    * means that this model instance can live at most as long as the current Application
    * @return the scope in which this model is managed
    */
   public WDModelScopeType getModelScope();

   /**
    * Gets the instance ID of this model instance
    *
    * This instance ID allows having more than one instance of a model within a single scope.
    * In case no specific Id was used, the model's fully qualified class name is returned.
    * @return the modelInstanceId of this model instance
    */
   public String getModelInstanceId();

}
