
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.cmi.model.ICMIQuery;
import com.sap.tc.webdynpro.services.api.WDHelperFactory;

/**
 * Helper class to create some special value sets.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/WDValueServices.java#2 $
 * @see IWDOnDemandValueSetService
 * @see IWDBoundValueSet
 */
public class WDValueServices {

  /**
   * Create an instance of IWDOnDemandValueSetService for context attributes
   * using <code>attrInfo</code> as metadata. <code>theSupplier</code> is a
   * reference to an application provided interface. This implementation is in
   * charge of retrieving the valueset on demand. There is no guarantee about
   * the time the supplying methods of this interface are called. It is up to
   * the framework to call at any time.<p>
   * 
   * <b>IMPORTANT NOTE:</b> This class creates a modifiable type for <code>attrInfo</code>
   * 
   * @param theSupplier is a reference to the supplying applcation code filling the valueset on demand
   * @param attrInfo is the context attribute using this valueset on demand 
   */
  public static IWDOnDemandValueSetService createOnDemandValueSet(IWDValueSupplier theSupplier, IWDAttributeInfo attrInfo) {
    return instance.createOnDemandValueSet(theSupplier, attrInfo);
  }



	/**
	 * Create an IWDBoundValueSet. IWDBoundValueSet is a utility class that can 
	 * bind a DropDownByKey UI element to a context node.<p>
	 * 
   * <b>IMPORTANT NOTE:</b> This class creates a modifiable type for <code>attrInfoSelectedKey</code>
	 * 
	 * @param attrInfoSelectedKey selectedKey's attribute info
	 * @param dataSource context node containing the valueset 
	 * @param attrInfoKey attribute info of the element storing the key in <code>dataSource</code>
	 * @param attrInfoValue attribute info of the element storing the value in <code>dataSource</code>. 
	 * @param isStaticValueSet true if the valueset content does not change at runtime.
	 * @see IWDBoundValueSet
	 */
	public static IWDBoundValueSet createBoundValueSet(IWDAttributeInfo attrInfoSelectedKey,
													IWDNode dataSource, IWDAttributeInfo attrInfoKey,IWDAttributeInfo attrInfoValue) 
	{
		 return instance.createBoundValueSet(attrInfoSelectedKey , dataSource, attrInfoKey, attrInfoValue, null);
	}

  /**
   * Create an IWDBoundValueSet. IWDBoundValueSet is a utility class that can 
   * bind a DropDownByKey UI element to a context node.<p>
   * 
   * <b>IMPORTANT NOTE:</b> This class creates a modifiable type for <code>attrInfoSelectedKey</code>
   * 
   * @param attrInfoSelectedKey selectedKey's attribute info
   * @param dataSource context node containing the valueset 
   * @param attrInfoKey attribute info of the element storing the key in <code>dataSource</code>
   * @param attrInfoValue attribute info of the element storing the value in <code>dataSource</code>. 
	 * @param listener interface for custom filter 
   * @see IWDBoundValueSet
   */
  public static IWDBoundValueSet createBoundValueSet(IWDAttributeInfo attrInfoSelectedKey,
                          IWDNode dataSource, IWDAttributeInfo attrInfoKey,IWDAttributeInfo attrInfoValue,
		                      IWDBoundValueSet.IWDFilterListener selection) 
  {
     return instance.createBoundValueSet(attrInfoSelectedKey, dataSource, attrInfoKey, attrInfoValue, selection );
  }

	/**
	 * adds ovs functionalities for the specified attributes.
	 * 
   * @param providerName - the name of the service, it is possible 
   * @param startupAttributes - the attributes, which will be marked as startup attributes / bound uielements will be shown with ovs button 
   * @param queryInputNode - the node for the query input structure
   * @param queryResultNode - the node for the result structure
   * @param queryListener - a listener which can be implemented, also null can be used. It receives the hooks for apply input values, query and apply result values.
   */
	public static void addOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes, IWDNode queryInputNode, IWDNode queryResultNode, IWDOVSContextNotificationListener queryListener){
		instance.addOVSExtension(providerName, startupAttributes, queryInputNode, queryResultNode, queryListener);
	}

	/**
	 * adds ovs extension to a valuenode/modelnode
	 * 
	 * @param providerName - the name of the service 
	 * @param startupAttributes - the attributes, which will be marked as startup attributes / bound uielements will be shown with ovs button 
	 * @param cmiQuery - the query 
	 * @param queryListener - a listener which can be implemented, also null can be used. It receives the hooks for apply input values, query and apply result values.
	 */
	public static void addOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes, ICMIQuery cmiQuery, IWDOVSNotificationListener queryListener){
		instance.addOVSExtension(providerName, startupAttributes, cmiQuery, queryListener);
	}

  /**
   * removes the ovs extension from the specified attributes
   * @param providerName - the name of the extension: if does not match, it is not removed.
   * @param startupAttributes - array of pointer to the attributes, where extension is removed.
   */
  public static void removeOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes){
    instance.removeOVSExtension(providerName, startupAttributes);
  }
  
  private static final IWDValueServices instance = (IWDValueServices)WDHelperFactory.getInstance(IWDValueServices.class);

  /**
   * Interface to the framework class doing the work.
   * 
   * @SAPWebDynproPart 2
   */
  public static interface IWDValueServices {

		/**
		 * Create an instance of IWDOnDemandValueSetService for context attributes
		 * using <code>attrInfo</code> as metadata. <code>theSupplier</code> is a
		 * reference to an application provided interface. This implementation is in
		 * charge of retrieving the valueset on demand. There is no guarantee about
		 * the time the supplying methods of this interface are called. It is up to
		 * the framework to call at any time.<p>
		 * 
     * <b>IMPORTANT NOTE:</b> This class creates a modifiable type for <code>attrInfo</code>
		 * 
		 * @param theSupplier is a reference to the supplying applcation code filling the valueset on demand
		 * @param attrInfo is the context attribute using this valueset on demand 
		 */
    IWDOnDemandValueSetService createOnDemandValueSet(IWDValueSupplier theSupplier, IWDAttributeInfo attrInfo);


		/**
		 * Create an IWDBoundValueSet. IWDBoundValueSet is a utility class that can 
		 * bind a DropDownByKey UI element to a context node.<p>
		 * 
     * <b>IMPORTANT NOTE:</b> This class creates a modifiable type for <code>attrInfoSelectedKey</code>
		 * 
		 * 
		 * @param attrInfoSelectedKey selectedKey's attribute info
		 * @param dataSource context node containing the valueset 
		 * @param attrInfoKey attribute info of the element storing the key in <code>dataSource</code>
		 * @param attrInfoValue attribute info of the element storing the value in <code>dataSource</code>.
		 * @param listener interface for custom filter 
		 * @param isStaticValueSet true if the valueset content does not change at runtime.
		 * @see IWDBoundValueSet
		 */
    IWDBoundValueSet createBoundValueSet(IWDAttributeInfo attrInfoSelectedKey,
                            IWDNode dataSource, IWDAttributeInfo attrInfoKey,IWDAttributeInfo attrInfoValue,
		                        IWDBoundValueSet.IWDFilterListener listener);
    
    /**
     * adds ovs functionalities for the specified attributes.
     * 
     * @param providerName - the name of the service, it is possible 
     * @param startupAttributes - the attributes, which will be marked as startup attributes / bound uielements will be shown with ovs button 
     * @param queryInputNode - the node for the query input structure
     * @param queryResultNode - the node for the result structure
     * @param queryListener - a listener which can be implemented, also null can be used. It receives the hooks for apply input values, query and apply result values.
     */
    public void addOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes, IWDNode queryInputNode, IWDNode queryResultNode, IWDOVSContextNotificationListener queryListener);

    /**
     * adds ovs extension to a valuenode/modelnode
     * 
     * @param providerName - the name of the service 
     * @param startupAttributes - the attributes, which will be marked as startup attributes / bound uielements will be shown with ovs button 
     * @param cmiQuery - the query 
     * @param queryListener - a listener which can be implemented, also null can be used. It receives the hooks for apply input values, query and apply result values.
     */
    public void addOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes, ICMIQuery cmiQuery, IWDOVSNotificationListener queryListener);

    /**
     * removes the ovs extension from the specified attributes
     * @param providerName - the name of the extension, if does not match, it is not removed.
     * @param startupAttributes - array of pointer to the attributes, where extension is removed.
     */
    public void removeOVSExtension(String providerName, IWDAttributeInfo[] startupAttributes);
}
}
