/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/WDOVSNotificationAdapter.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Abstract "do nothing" implementation of the {@link IWDOVSNotificationListener}
 * interface. Can be helpful as a base class for application specific listener
 * implementations as these implementations then don't have to implement methods
 * they are not interested in.
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 */
public class WDOVSNotificationAdapter implements IWDOVSNotificationListener {

  /**
   *	adapter with not implemented methods, feel free to overwrite the methods you need 
   */
  public WDOVSNotificationAdapter() {
    super();
  }

  /**
   * @see IWDOVSNotificationListener#onQuery(Object)
   **/
  public void onQuery(Object inputModelClass) {
  }

  /**
   * @see IWDOVSNotificationListener#applyResult(IWDNodeElement, Object)
   **/
  public void applyResult(IWDNodeElement applicationNodeElement, Object queryModelClass) {
  }

  /**
   * @see IWDOVSNotificationListener#applyInputValues(IWDNodeElement, Object)
   **/
  public void applyInputValues(IWDNodeElement applicationNodeElement, Object inputModelClass) {
  }

}
