/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/WDOVSContextNotificationAdapter.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Abstract "do nothing" implementation of the {@link IWDOVSContextNotificationListener}
 * interface. Can be helpful as a base class for application specific listener
 * implementations as these implementations then don't have to implement methods
 * they are not interested in.
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 */
public class WDOVSContextNotificationAdapter implements IWDOVSContextNotificationListener {

	/**
	 *	adapter with not implemented methods, feel free to overwrite the methods you need 
	 */
  public WDOVSContextNotificationAdapter() {
    super();
  }

  /**
   * @see com.sap.tc.webdynpro.progmodel.api.IWDOVSContextNotificationListener#onQuery(com.sap.tc.webdynpro.progmodel.api.IWDNodeElement, com.sap.tc.webdynpro.progmodel.api.IWDNode)
   **/
  public void onQuery(IWDNodeElement queryInputNodeElement, IWDNode queryOutputNode) {
  }

  /**
   * @see com.sap.tc.webdynpro.progmodel.api.IWDOVSContextNotificationListener#applyResult(com.sap.tc.webdynpro.progmodel.api.IWDNodeElement, com.sap.tc.webdynpro.progmodel.api.IWDNodeElement)
   **/
  public void applyResult(IWDNodeElement applicationNodeElement, IWDNodeElement queryOutputNodeElement) {
  }

  /**
   * @see com.sap.tc.webdynpro.progmodel.api.IWDOVSContextNotificationListener#applyInputValues(com.sap.tc.webdynpro.progmodel.api.IWDNodeElement, com.sap.tc.webdynpro.progmodel.api.IWDNodeElement)
   **/
  public void applyInputValues(IWDNodeElement applicationNodeElement, IWDNodeElement queryInputNodeElement) {
  }

}
