/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDViewElement.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Generic API of all view elements, visible or otherwise.
 * This interface represents the lowest level of commonality that exists across
 * all elements within a view. The resulting elements based on this interface do
 * not necessarily correspond to elements visible on the client (for example,
 * <code>IWDFlowData</code>).
 * 
 * A view element knows its containing view and an ID that is unique within that view.
 * 
 * This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDViewElement.java#1 $
 */
public interface IWDViewElement
{
  /**
   * Returns the ID that uniquely identifies this view element within its
   * containing view.
   */
  public String getId();

  /**
   * Returns the API of the containing view.
   */
  public IWDView getView();
  
  /**
   * Requests to change the keyboard input focus to this view element.
   * It is undefined which focus request wins if there are several ones.
   * The request may silently fail, but is guaranteed not to throw an exception.
   * 
   * If this view element is a table cell editor, its occurence in the current
   * row (according to the context's lead selection) will receive focus. Similar
   * things will happen inside other containers that display multiple occurences
   * of the same view element.
   */
  public void requestFocus();
}
