/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDViewController.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import java.util.Map;

import com.sap.tc.webdynpro.progmodel.repository.IWDAbstractViewInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDOutboundPlugInfo;

/**
 * Generic API of all view controllers.
 * 
 * This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDViewController.java#1 $
 */
public interface IWDViewController extends IWDController
{
  /**
   * Returns the runtime repository information for this view.
   */
  public IWDAbstractViewInfo getViewInfo();

  /**
   * Fires the given outbound plug with the given parameters.
   * Firing a plug of type "Standard" performs the navigation defined for the
   * link starting at that plug.
   * Firing a plug of type "Exit" defined in an interface view of the top-level
   * component causes the application to terminate.
   */
  public void firePlug(IWDOutboundPlugInfo plug, Map parameters);
  
  /**
   * Requests to change the keyboard input focus to the UI element whose
   * primary purpose is to raise an event bound to the given action.
   * If there is more than one such UI element, then it is undefined which UI
   * element is chosen. It is also undefined which focus request wins if there
   * are several ones. The request may silently fail, but is guaranteed not to
   * throw an exception.
   * 
   * UI elements (e.g. table) that trigger events (e.g. "onLeadSelect"), but are
   * not primarily used to do so, are probably considered with lower priority
   * or not at all. As a rule of thumb, if disabling the action disables the
   * whole UI element, then that UI element is primarily used to trigger the
   * event bound to that action.
   * 
   * Example: If you have a button whose "onAction" event is bound against the
   * action XYZ and no other UI element event is bound against XYZ, then a
   * <code>wdThis.wdGetAPI().requestFocus(wdThis.wdGetXYZAction())</code> will
   * focus on that button.
   * 
   * Note how this allows to keep controller code independent of the UI, even
   * of IDs used for UI elements. If the button in the example above is later
   * replaced by a <code>LinkToAction</code> or some fancy new icon button that
   * lives inside a tray's header, the code to request focus remains unaffected.
   */
  public void requestFocus(IWDAction action);

  /**
   * Requests to change the keyboard input focus to the UI element whose
   * primary use is to edit a property bound to the given attribute.
   * If there is more than one such UI element, then it is undefined which UI
   * element is chosen. It is also undefined which focus request wins if there
   * are several ones. The request may silently fail, but is guaranteed not to
   * throw an exception.
   * 
   * UI elements that are read-only or disabled are not considered at all.
   * 
   * To identify a given attribute uniquely at runtime, you must specify the
   * node element to which that attribute belongs.
   * This will e.g. identify a specific cell in a given table row.
   * 
   * Example: If you have an input field whose "value" property is bound against
   * the attribute abc of node XYZ of this view called MyView and no other UI
   * element property is bound against XYZ.abc, then the following code will
   * focus on that input field.
   * <pre>
   * IWDAttributeInfo attribute
   *   = wdContext.nodeXYZ().getNodeInfo().getAttribute(
   *       IPrivateMyView.IXYZElement.ABC);
   * wdThis.wdGetAPI().requestFocus(wdContext.currentXYZElement(), attribute);
   * </pre>
   * 
   * Note how this allows to keep controller code independent of the UI, even
   * of IDs used for UI elements. If the input field in the example above is later
   * replaced by a <code>DropDownByKey</code> or some fancy new editor with
   * "guess what I want" value help, the code to request focus remains unaffected.
   */
  public void requestFocus(IWDNodeElement nodeElement, IWDAttributeInfo attribute);
}
