/* Title:        Web Dynpro Java Runtime: 
 * Description:  
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author SAP
 * @version      $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDValueSupplier.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import java.util.Locale;
import java.util.Map;

import com.sap.typeservices.IModifiableSimpleValueSet;

/**
 * Interface for dynamic reload of valuesets on demand. 
 * @SAPWebDynproPart 1
 */
public interface IWDValueSupplier	extends IWDValueSetSource {

  /**
   * Implement this method in order to supply the necessary valueset on demand.
   * 
   * @param initialSet is an empty valueset to be filled by this method.
   * 
   * @param locale of the valueset's display text. 
   * 
   * @return true, if valueset should be loaded on demand only once and keeps stable afterwards, returns false 
   * if valueset should be reloaded again when the user clicks the "request valueset button"
   */
  boolean supplyValues(IModifiableSimpleValueSet initialSet, Locale locale);





  /**
   * Implement this method in order to supply the necessary valueset on demand.
   * 
   * @param initialSet is an empty valueset to be filled by this method.
   * 
   * @param locale of the valueset's display text. 
   * 
   * @param Filter are the current filter values entered by the use.
   * 
   * @exception UnsupportedOperationException in case the method cannot be implmented. 
   * In this case base interface method @link IWDValueSetSource#supportFilter() must return <code>false</code>!
   */
  void supplyFilteredValues(IModifiableSimpleValueSet initialSet, Locale locale, IWDValueFilter Filter);

}
