/* Title:        Web Dynpro Java Runtime: Validation API
 * Description:  plublic application interface for validation checks and access to external string values
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author SAP
 * @version      $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDValidationCheck.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * 
 * IWDValidationCheck offers access to the Web Dynpro validation managemnt service. The main purpose of
 * this interface is:
 * <li>Read validation information for context attributes</li>
 * <li>Set validation information for context attributes</li>
 * <li>Access external string representation of a context attribute</li>
 * 
 * @SAPWebDynproPart 2
 */
public interface IWDValidationCheck {
  /**
  * Check if a context attribute is valid.
  * 
  * @return true, when the given context is valid.
  */
  public boolean isValidAttribute(IWDNodeElement elem, 
                          IWDAttributeInfo attr); 

  // For both methods it is not clearly defined how to deal with mapped attributes -->
  // do not offer them :(
  /**
  * Check if all context attributes are valid which are descendants relative to <code>elem</code>.
  * 
  * @return true, if all dependant attributes are valid.
  */
  public boolean isValidNodeElement(IWDNodeElement elem); 

  /**
  * Check if all context attributes are valid which are descendants relative to <code>node</code>.
  * 
  * @return true, if all dependant attributes are valid.
  */
  public boolean isValidNode(IWDNode node);

  /**
  * Set an attribute to valid. Later checks for non validating action event handlers can execute if the 
  * event handler is dependent on this attribute. <p>
  * NOTE: This method only sets the validation state of the attribute. It neither runs any validation 
  * routine nor is any further framework funtionality involved. It is up to the usage of this API to 
  * guarantee that validating an attribute is done in a reasonable manner. 
  * 
  */
  public void setAttributeValid(IWDNodeElement elem,
                         IWDAttributeInfo attr); 

  // For both methods it is not clearly defined how to deal with mapped attributes -->
  // do not offer them :(
  /**
  * Set all dependent attributes of an element to valid. Later checks for non validating action event handlers can execute if 
  * the event handler is dependent on these attributes. <p>
  * 
  * Also consider note @see #setAttributeValid(IWDNodeElement,IWDAttributeInfo )
  */
  // public void setElementValid(IWDNodeElement elem); 

  /**
  * Set all dependent attributes of an entire node to valid. Later checks for non validating action event handlers can execute if 
  * the event handler is dependent on these attributes. <p>
  * 
  * Also consider note @see #setAttributeValid(IWDNodeElement,IWDAttributeInfo )
  */
  // public void setNodeValid(IWDNode node); 

  /**
   * Get access to the external string representation of an context  attribute. This method returns either the
   * string representation according to the data types format method or the string entered by the user in case the 
   * input can not be converted to the proper typed java representation. In any case this method returns the string
   * as it will be displayed in the UI with the next repsonse send to the client. 
   * 
   * @return external string representation of the attribute. 
   */
  public String getExternalValue(IWDNodeElement nodeElement, 
                        IWDAttributeInfo attrInfo); 

}
