
// ---------------------------------------------------------------------------
// This file has been generated by the Web Dynpro Code Generator
// Note: Manual changes should only take place in the user coding areas
//       i.e. the blocks marked with //@@begin ... //@@end
// ---------------------------------------------------------------------------

/*
 * SAP Copyright (c) 2002
 * All rights reserved
 */

//@@begin version
// @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDUIElementContainer.java#3 $
//@@end

package com.sap.tc.webdynpro.progmodel.api;

import java.util.Iterator;
import com.sap.tc.webdynpro.progmodel.api.IWDAttributeInfo;
import com.sap.tc.webdynpro.progmodel.api.IWDNodeInfo;
// used libraries
import com.sap.tc.webdynpro.progmodel.api.*; // Core
//@@begin imports
//@@end

/**
 * Web Dynpro UIElementContainer API.
 *
 * UIElementContainer is the abstract base class of all UI elements that
 * may contain a number of arbitrary UI elements called its children.
 * <p>
 * A container manages its children using an instance of Layout. The layout defines how
 * the children are arranged in their container. A UI element that is managed
 * by a layout may provide layout data carrying individual layout information.
 * <p>
 * The size of the container is specified using the attributes <code>width</code> and <code>height</code>.
 * Width and height may be specified by CSS (cascading-style-sheet) size values.
 * This is a percentage value like "50%", a pixel value like "100px" or
 * a relative font size value like "1.5em" or "1ex".
 * <p>
 *
 * <p>This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!</p>
 *
 * @author SAP
 * @see IWDLayout
 * @see IWDLayoutData
 * @SAPWebDynproPart 2
 */
public interface IWDUIElementContainer extends IWDUIElement
{
  
  /**
   * Default value of property <code>height</code>.
   */
  public static final String DEFAULT_HEIGHT = "";
  
  /**
   * Default value of property <code>width</code>.
   */
  public static final String DEFAULT_WIDTH = "";

  /* Bound Property
     Name: height, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>height</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the height
   *                property is bound
   */
  public void bindHeight(String path);

  /**
   * Binds property <code>height</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       height property is bound
   */
  public void bindHeight(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>height</code>.
   *
   * @return        the path of the context attribute to which the height
   *                is currently bound
   */
  public String bindingOfHeight();

  /**
   * Returns the value of the <code>height</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the height (CSS size ) of this container.
   *
   * @return      the current value of the height property
   * @see #setHeight(String)
   */
  public String getHeight();

  /**
   * Sets property <code>height</code> to the new value.
   *
   * @param value     the new value of the height property
   * @see #getHeight()
   */
  public void setHeight(String value);

  /* Bound Property
     Name: width, Visibility: public, Type: String
     convertible: false
  */

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by <code>path</code>.
   *
   * @param path    the path of the context attribute to which the width
   *                property is bound
   */
  public void bindWidth(String path);

  /**
   * Binds property <code>width</code> to the context attribute
   * specified by the given attribute info.
   *
   * @param attributeInfo  the info of the context attribute to which the
   *                       width property is bound
   */
  public void bindWidth(IWDAttributeInfo attributeInfo);

  /**
   * Binding path of property <code>width</code>.
   *
   * @return        the path of the context attribute to which the width
   *                is currently bound
   */
  public String bindingOfWidth();

  /**
   * Returns the value of the <code>width</code> property.
   * The initial value is <code>""</code>.
   *
   * Determines the width (CSS size ) of this container.
   *
   * @return      the current value of the width property
   * @see #setWidth(String)
   */
  public String getWidth();

  /**
   * Sets property <code>width</code> to the new value.
   *
   * @param value     the new value of the width property
   * @see #getWidth()
   */
  public void setWidth(String value);

  /* outgoing aggregation:
     Name=UIElementContainer.Children, isAbstract=false
Role A: Name=Children, Navigable=true, Aggregation=false, Cardinality=multiple
Role B: Name=Container, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Adds the given Child at the end of the list of Children.
   *
   * @param aUIElement     the Child to be added into the list
   * @see #getChildren()
   */
  public void addChild(IWDUIElement aUIElement);

  /**
   * Adds the given Child at the specified index in the list of Children.
   *
   * @param aUIElement     the Child to be added into the list
   * @param index             zero based index of the insertion position in the list
   * @see #getChildren()
   */
  public void addChild(IWDUIElement aUIElement, int index);

  /**
   * Swaps the Children at the given indices.
   * 
   * @param i index of the first Child to swap
   * @param j index of the second Child to swap
   * @throws IndexOutOfBoundsException If one of the indices is out of bounds
   */
  public void swapChildren(int i, int j); 
   
  /**
   * Returns the list of Children.
   *
   * A container may contain a number of arbitrary UI elements called its children.
   * The parent-child relation is used to construct the UI tree.
   *
   * @return      an array containing references to the current Children
   */
  public IWDUIElement[] getChildren();

  /**
   * Returns the Child at the given index.
   *
   * @return Child at the given index
   */
  public IWDUIElement getChild(int index);

  /**
   * Returns the index of the given element in the list of Children
   * or <code>-1</code> if it is not contained in the list.
   */
  public int indexOfChild(IWDUIElement aUIElement);
       
  /**
   * Returns the number of Children.
   * 
   * @return the current number of Children.
   * @see #getChildren()
   */
  public int numberOfChildren();
  
  /**
   * Checks if there exist Children.
   *
   * @return      <code>true</code> if there are Children;
   *              <code>false</code> otherwise.
   * @see #getChildren()
   */
  public boolean hasChildren();

  /**
   * Returns an iterator over the list of Children.
   *
   * @return      an iterator over the current Children
   * @see #getChildren()
   */
  public Iterator iterateChildren();

  /**
   * Removes the entry at the given index from the list of Children.
   * This does not destroy the removed element, i.e. it may be added again!
   *
   * @param index       zero based index of the deletion position in the list
   * @return            the removed element
   * @see #addChild(IWDUIElement)
   * @see #getChildren()
   */
  public IWDUIElement removeChild(int index);

  /**
   * Removes the entry with the given ID from the list of Children.
   * This does not destroy the removed element, i.e. it may be added again!
   * 
   * @param id          unique ID of the element to be deleted from the list
   * @return            the removed element
   * @see #addChild(IWDUIElement)
   * @see #getChildren()
   */
  public IWDUIElement removeChild(String id);

  /**
   * Removes all entries from the list of Children.
   * This does not destroy the removed elements, i.e. they may be added again!
   * 
   * @see #addChild(IWDUIElement)
   * @see #getChildren()
   */
  public void removeAllChildren(); 

  /**
   * Destroys all entries in the list of Children.
   * Destroyed elements do not exist any longer, i.e. new elements may be
   * created with the same IDs.
   */
  public void destroyAllChildren();

  /* outgoing aggregation:
     Name=UIElementContainer.Layout, isAbstract=false
Role A: Name=Layout, Navigable=true, Aggregation=false, Cardinality=single
Role B: Name=UIElementContainer, Navigable=true, Aggregation=true, Cardinality=single
  */

  /**
   * Gets the Layout instance.
   *
   * A container manages the layout of its children using an associated
   * layout manager.
   *
   * @return      the current Layout
   * @see #createLayout(Class)
   */
  public IWDLayout getLayout();

//@@begin extensions

  /**
   * Creates and sets a layout of the given type.
   *
   * @param layoutInterface the type of layout to be created
   * @return the layout created
   */
  public IWDLayout createLayout(Class layoutInterface);

//@@end

}
