/*
 * Copyright (c) 2003-2004 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDOVSNotificationListener.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Callback interface that must be implemented by applications that 
 * use an OVS based on an ICMIQuery. </p>
 * 
 * This type is intended to be implemented by applications using Web Dynpro.</p>
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDOVSNotificationListener.java#1 $
 */
public interface IWDOVSNotificationListener {

	/**
	 * notifies about a request of a query
	 * @param inputModelClass, the input modelclass, which delivers the necessary input for the query
	 */
	void onQuery(Object inputModelClass);
  
	/**
	 * notifies about the successful selection of a result element, now it's the moment to
	 * apply the query result to the application node. Selected element is marked by leadselection
   * Important: this event is not called, if the attribute, from which the ovs is started, is readonly.
	 * @param applicationNodeElement, the parent node element of the attribute, for which ovs was started in the application
	 * @param queryModelClass, the result modelclass of the query
	 */
	void applyResult(IWDNodeElement applicationNodeElement, Object queryModelClass);
  
	/**
	 * notifies about the moment, when application data can be applied to the data, which is shown in the search mask.
	 * @param applicationNodeElement, the parent node element of the attribute, for which ovs was started in the application
	 * @param inputModelClass, the modelclass which is shown in the search mask
	 */
	void applyInputValues(IWDNodeElement applicationNodeElement, Object inputModelClass);
  
}
