/*
 * Copyright (c) 2003-2004 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDOVSContextNotificationListener.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Callback interface that must be implemented by applications that 
 * use a context based OVS. </p>
 * 
 * This type is intended to be implemented by applications using Web Dynpro.</p>
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDOVSContextNotificationListener.java#1 $
 */
public interface IWDOVSContextNotificationListener {
  
	/**
	 * notifies about a request of a query
	 * @param queryInputNode, the node of input parameters for the query
	 * @param queryOutputNode, the output node, where the result of the query has to be inserted
	 */
	void onQuery(IWDNodeElement queryInputNodeElement, IWDNode queryOutputNode);
  
	/**
	 * notifies about the successful selection of a result element, now it's the moment to
	 * apply the query result to the application node. Selected element is marked by leadselection
	 * @param applicationNodeElement, the parent node element of the attribute, for which ovs was started in the application
	 * @param queryOutputNode, the result node of the query
	 */
	void applyResult(IWDNodeElement applicationNodeElement, IWDNodeElement queryOutputNodeElement);
  
	/**
	 * notifies about the moment, when application data can be applied to the data, which is shown in the search mask.
	 * @param applicationNodeElement, the parent node element of the attribute, for which ovs was started in the application
	 * @param queryInputNode, the node which is shown in the search mask
	 */
	void applyInputValues(IWDNodeElement applicationNodeElement, IWDNodeElement queryInputNodeElement);
  
}
