package com.sap.tc.webdynpro.progmodel.api;

/**
 * A listener that can receive notifications that are passed along the mapping via
 * {@link IWDNode#notifyAllMappedNodes(Object)}.
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDNodeNotificationListener.java#1 $
 */
public interface IWDNodeNotificationListener {
  /**
   * The notification sent via the mapping chain.
   * @param notifiedNode The node that has been notified
   * @param notificationSource The node that this notification has been started at
   * @param payload The payload passed in the notification
   */
  void notify(IWDNode notifiedNode, IWDNode notificationSource, Object payload);
}
