package com.sap.tc.webdynpro.progmodel.api;

/**
 * Interface used to set up a dynamic dispose "function".
 * @author SAP
 * @SAPWebDynproPart 1
 */
public interface IWDNodeCollectionDisposer {
  /**
   * Method called if a value node has been modified and is about to be
   * destroyed.
   * <p>
   * This method is called if any of its elements has set the changedByClient
   * flag and either
   * <ul>
   * <li> the node is singleton and its parent has changed the lead selection
   * <li> the parent element has become invalid
   */
  void disposeElements(IWDNode node);
}
