/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDModifiableBinaryType.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.webdynpro.services.sal.url.api.WDWebResourceType;

/**
 * The interface IWDModifiableBinaryType represents a special Web Dynpro 
 * implementation of the Java DDIC's binary type.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDModifiableBinaryType {
  /**
   * Returns the mimeType.
   * @return WebResourceType
   */
  public WDWebResourceType getMimeType();

  /**
   * Sets the mimeType.
   * @param mimeType The mimeType to set
   */
  public void setMimeType(WDWebResourceType mimeType);

  /**
   * Method getFileName returns the name of the web resource
   * @return
   */
  public String getFileName();
   
  /**
   * Method setFileNameForDownLoad.
   * @param string
   */
  public void setFileName(String string);
}
