/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDController.java#2 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.webdynpro.progmodel.repository.IWDControllerInfo;

/**
 * Generic API of all Web Dynpro controllers.
 * All controllers created by the Web Dynpro toolset implement this interface.
 * 
 * Unless explicitly stated, the methods listed for this interface are not
 * available to parent components through the component usage interface.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDController.java#2 $
 */

public interface IWDController {

  /**
   * Returns the action with name <code>name</code> or <code>null</code>.
   * @param name name of the action to be returned
   * @return requesed action or null, if it does not exist
   */
  IWDAction getAction(String name);

  /**
   * Returns the component this controller belongs to.
   * @return the component this controller belongs to
   */
  IWDComponent getComponent();

  /**
   * Returns the context of this controller.
   * This method is visible through the component usage interface.
   * @return the context of this controller
   */
  IWDContext getContext();

  /**
   * Returns the metadata describing this controller.
   * @return the controller metadata object
   */
  public IWDControllerInfo getControllerInfo();

  /**
   * Returns a localized message text for the given <code>key</code>.
   * @param key the key of the localized message
   * @return the localized message text
   * @deprecated This method may be withdrawn with the first new NetWeaver release in 2006.
   *   Use {@link IWDTextAccessor#getText(String)} instead (see {@link IWDComponent#getTextAccessor()}
   *   on how to get access to an <code>IWDTextAccessor<code>).
   */
  String getMessage(String key);

  /**
   * Returns a message text corresponding to <code>key</code> that is both localized,
   * and formatted according to <code>parameters</code>.
   * @param key the key of the localized message
   * @param parameters object array of parameters
   * @return a localized message text
   * @deprecated This method may be withdrawn with the first new NetWeaver release in 2006.
   *   Use {@link IWDTextAccessor#getText(String, Object[])} instead (see {@link IWDComponent#getTextAccessor()}
   *   on how to get access to an <code>IWDTextAccessor<code>).
   */
  String getMessage(String key, Object parameters[]);

  /**
   * Returns a localized message text for the given <code>key</code>.
   * @param key the key of the localized text
   * @return the localized message text
   * @deprecated This method may be withdrawn with the first new NetWeaver release in 2006. 
   *   Use {@link IWDTextAccessor#getText(String)} instead (see {@link IWDComponent#getTextAccessor()}
   *   on how to get access to an <code>IWDTextAccessor<code>).
   */
  String getText(String key);

  /**
   * Returns a message text corresponding to <code>key</code> that is both localized,
   * and formatted according to <code>parameters</code>.
   * @param key the key of the localized text
   * @param parameters object array of parameters
   * @return the message text 
   * @deprecated This method may be withdrawn with the first new NetWeaver release in 2006.
   *   Use {@link IWDTextAccessor#getText(String, Object[])} instead (see {@link IWDComponent#getTextAccessor()}
   *   on how to get access to an <code>IWDTextAccessor<code>).
   */
  String getText(String key, Object parameters[]);

  /**
   * Returns the name of this controller.
   * @return the name of this controller
   */
  String getName();

  /**
   * Returns the package part of the qualified name of this controller.
   * @return the package part of the qualified name of this controller
   */
  String getPackageName();

  /**
   * Returns the qualified name of this controller.
   * @return the qualified name of this controller
   */
  String getQualifiedName();
}
