/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDAction.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.webdynpro.services.event.api.IWDParameters;

/**
 * Offers access to actions of a controller.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDAction.java#1 $
 */
public interface IWDAction 
{
  /**
   * method returns this action's controller.
   * @return this action's IWDController
   */
  public IWDController getController();

  /**
   * Returns this action's descriptive localized text.
   * @return Action's text
   */
  public String getText();

  /**
   * Set this action's descriptive localized text.
   *
   */
  public void setText(String text);

  /**
   * Returns this action's image url.
   * @return image url
   */
  public String getImage();

  /**
   * Set this action's image url.
   *
   */
  public void setImage(String imageUrl);

  /**
   * method tells whether the action is currently enabled.
   * @return whether the action is currently enabled
   */
  public boolean isEnabled();

  /**
   * Determines whether the action is enabled.
   * @param enabled flag which indicates whether the action is enabled
   */
  public void setEnabled(boolean enabled);
  

  /**
   * This method tells whether the action is a validating actions.
   * @return true, if this action is validating.
   */
  public boolean isValidating();
  

  /**
   * Get access to action parameters for this action's next eventhandler call. This method is 
   * only needed in case a non validating actions returns a validatating 
   * action and the returned validating action needs parameters. 
   * In that case it is legal to fill the parameters of the returned validating
   * action within the non validating event handler. 
   * 
   * In all other cases this method does nothing
   * 
   * @param name is the name of the parameter
   * @param value is the parameter value.
   */
  public IWDParameters getActionParameters();

}
