/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.xml;

import org.xml.sax.*;

/**
 * Strict error handler (reporting rather than discarding exceptions on errors
 * and fatal errors). <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: StrictErrorHandler.java,v 1.3 2003/03/28 18:08:08 jre Exp $
 */

public class StrictErrorHandler implements ErrorHandler {

  private final static StrictErrorHandler INSTANCE = new StrictErrorHandler();

  public static ErrorHandler getInstance() {
    return INSTANCE;
  }

  public void warning(SAXParseException ex) { }

  public void error(SAXParseException ex)
    throws SAXException {
    throw ex;
  }

  public void fatalError(SAXParseException ex)
    throws SAXException {
    throw ex;
  }
}
