/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.xml;

import java.io.IOException;
import org.xml.sax.InputSource;

import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/**
 * Extends {@link org.xml.sax.XMLReader} by pull-parsing methods. <p>
 *
 * Copyright (c) SAP AG 2003
 *
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IXMLExtReader.java,v 1.1 2003/03/31 09:15:35 sei Exp $
 */
public interface IXMLExtReader extends XMLReader {

  /**
   * Set the input source for the reading, but does not start parsing yet.
   *
   * @param source of input
   * @exception SAXException Exception raised in failure situation
   */
  void setInput(InputSource source)
    throws SAXException;

  /**
   * Parse the next (couple of) events, may be only one, and invoke them against
   * the installed {@link org.xml.sax.ContentHandler}. The reader should ideally
   * only fire one event, but is allowed to generate more to ease internal state
   * management. Returns if end of input was reached.
   *
   * @return if end of input was reached.
   * @exception SAXException Exception raised in failure situation
   * @exception IOException Exception raised in failure situation
   */
  boolean parseNextEvents()
    throws SAXException, IOException;

  /**
   * Completely parse the input source.
   *
   * @exception IOException Exception raised in failure situation
   * @exception SAXException Exception raised in failure situation
   */
  void parse()
    throws IOException, SAXException;

  /**
   * Free all allocated resources. Not necessary to call when parsing has
   * finished.
   */
  void discard();
}
