/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.usermanagement;
import com.sap.tc.logging.Location;
import com.sapportals.portal.security.usermanagement.*;

import com.sapportals.wcm.crt.*;
import com.sapportals.wcm.util.logging.LoggingFormatter;

import java.lang.reflect.Method;

/**
 * TBD: Description of the class.
 */
public final class WPUMFactory {

  private final static Location TRACE = Location.getLocation(WPUMFactory.class);
  
  private final static String USER_ICON = "user.gif";
  private final static String GROUP_ICON = "group.gif";
  private final static String ROLE_ICON = "role.gif";

  private static IUMFactory g_umFactory = null;
  private static IPortalLogin g_Authenticator = null;
  private static IUserFactory g_UserFactory = null;
  private static IGroupFactory g_GroupFactory = null;
  private static IRoleFactory g_RoleFactory = null;
  private static IServiceUserFactory g_ServiceUserFactory = null;
  private static IUMEventHandler g_EventHandler = null;
  private static boolean isInitialized = false;
  private static Class portalServiceClass = null;

  /*
   * static {
   * / first try to get the portal UM service
   * Class portalServiceClass = null;
   * try {
   * portalServiceClass = Class.forName("com.sapportals.wcm.portal.service.PortalService");
   * }
   * catch (Exception e) {
   * g_log.info("Cannot get WCM PortalService class");
   * }
   */
  public static void setPortalServiceClass(Class c) {
    WPUMFactory.portalServiceClass = c;
  }

  private static void init() {
    if (WPUMFactory.isInitialized) {
      return;
    }

    if (WPUMFactory.portalServiceClass != null) {
      try {
        Method method = null;
        method = portalServiceClass.getMethod("getUserFactory", null);
        if (method != null) {
          g_UserFactory = (IUserFactory)method.invoke(null, null);
        }
        if (g_UserFactory != null) {
          method = portalServiceClass.getMethod("getServiceUserFactory", null);
          if (method != null) {
            g_ServiceUserFactory = (IServiceUserFactory)method.invoke(null, null);
          }
          method = portalServiceClass.getMethod("getAuthenticator", null);
          if (method != null) {
            g_Authenticator = (IPortalLogin)method.invoke(null, null);
          }
          method = portalServiceClass.getMethod("getGroupFactory", null);
          if (method != null) {
            g_GroupFactory = (IGroupFactory)method.invoke(null, null);
          }
          method = portalServiceClass.getMethod("getRoleFactory", null);
          if (method != null) {
            g_RoleFactory = (IRoleFactory)method.invoke(null, null);
          }
          method = portalServiceClass.getMethod("getEventHandler", null);
          if (method != null) {
            g_EventHandler = (IUMEventHandler)method.invoke(null, null);
          }
        }
      }
      catch (Throwable ex) {
            //$JL-EXC$        
        TRACE.infoT("Cannot instantiate CM PortalService class: " + LoggingFormatter.extractCallstack(ex));
      }
    }

    if (g_UserFactory == null) {
      // portal service not found, try to access UMFactory directly.
      Class umFactory = null;
      try {
        umFactory = Class.forName("com.sapportals.portal.security.usermanagement.UMFactory");
        if (umFactory == null) {
          TRACE.fatalT("Cannot get Usermanagement Factory class");
        }
      }
      catch (Exception ex) {
            //$JL-EXC$
				TRACE.fatalT("Cannot get Usermanagement Factory class: " + LoggingFormatter.extractCallstack(ex));
      }

      if (umFactory != null) {
        try {
          // call umFactory.getInstance via reflection
          Method method = null;
          Object umFactoryImpl = null;
          method = umFactory.getMethod("getInstance", null);
          if (method != null) {
            umFactoryImpl = method.invoke(null, null);
            g_umFactory = (IUMFactory)umFactoryImpl;
          }
          if (g_umFactory == null) {
             TRACE.fatalT("Cannot instantiate Usermanagement Factory");
          }
          else {
            g_Authenticator = g_umFactory.getAuthenticator();
            g_UserFactory = g_umFactory.getDefaultFactory();
            g_GroupFactory = g_umFactory.getGroupFactory();
            g_RoleFactory = g_umFactory.getRoleFactory();
            g_EventHandler = g_umFactory.getEventHandler();
            method = umFactory.getMethod("getServiceUserFactory", null);
            if (method != null) {
              g_ServiceUserFactory = (IServiceUserFactory)method.invoke(umFactoryImpl, null);
            }
          }
        }
        catch (Throwable ex) {
            //$JL-EXC$
          TRACE.fatalT("Cannot instantiate Usermanagement Factory: " + LoggingFormatter.extractCallstack(ex));
        }
      }

    }
    isInitialized = true;
  }

  public static IUserFactory getUserFactory() {
    init();
    return g_UserFactory;
  }

  public static IPortalLogin getAuthenticator() {
    init();
    return g_Authenticator;
  }

  public static IGroupFactory getGroupFactory() {
    init();
    return g_GroupFactory;
  }

  public static IRoleFactory getRoleFactory() {
    init();
    return g_RoleFactory;
  }

  public static IServiceUserFactory getServiceUserFactory() {
    init();
    return g_ServiceUserFactory;
  }

  public static IUMEventHandler getEventHandler() {
    init();
    return g_EventHandler;
  }

  /*
   * simple search functions (as used in user selection)
   */
  public static ISearchUser getSimpleSearchUser(String searchText, boolean returningAttributes)
    throws UserManagementException {
    IUserFactory uf = getUserFactory();
    ISearchUser su = uf.getSearchUser();

    su.setValuesForKey(IUMPrincipal.DISPLAYNAME, new String[]{searchText});
    su.setValuesForKey(IUMPrincipal.DISPLAYID, new String[]{searchText});
    // su.setValuesForKey(IUMPrincipal.DESCRIPTION, new String[]{searchText});
    su.setSearchMethod(ISearchUMPrincipal.SEARCHMETHOD_OR);

    if (returningAttributes) {
      su.setReturningAttributes(new String[]{IUMPrincipal.DISPLAYNAME, IUMPrincipal.DISPLAYID});
    }

    return su;
  }

  public static String[] simpleUserSearch(String searchText) {
    try {
      IUserFactory uf = getUserFactory();
      ISearchUser su = getSimpleSearchUser(searchText, false);
      return uf.findUsers(su, 0);
    }
    catch (Exception ex) {
            //$JL-EXC$      
      TRACE.errorT("Usermanagement failure while retrieving users: " +  LoggingFormatter.extractCallstack(ex));
      return null;
    }
  }

  public static ISearchGroup getSimpleSearchGroup(String searchText, boolean returningAttributes)
    throws UserManagementException {
    IGroupFactory gf = getGroupFactory();
    ISearchGroup sg = gf.getSearchGroup();

    sg.setValuesForKey(IUMPrincipal.DISPLAYNAME, new String[]{searchText});
    sg.setValuesForKey(IUMPrincipal.DISPLAYID, new String[]{searchText});
    sg.setValuesForKey(IUMPrincipal.DESCRIPTION, new String[]{searchText});
    sg.setSearchMethod(ISearchUMPrincipal.SEARCHMETHOD_OR);

    if (returningAttributes) {
      sg.setReturningAttributes(new String[]{IUMPrincipal.DISPLAYNAME, IUMPrincipal.DISPLAYID, IUMPrincipal.DESCRIPTION});
    }

    return sg;
  }

  public static String[] simpleGroupSearch(String searchText) {
    try {
      IGroupFactory gf = getGroupFactory();
      ISearchGroup sg = getSimpleSearchGroup(searchText, false);
      return gf.findGroups(sg, 0);
    }
    catch (Exception ex) {
            //$JL-EXC$      
      TRACE.errorT("Usermanagement failure while retrieving groups: " + LoggingFormatter.extractCallstack(ex));
      return null;
    }
  }

  public static ISearchRole getSimpleSearchRole(String searchText, boolean returningAttributes)
    throws UserManagementException {
    IRoleFactory rf = getRoleFactory();
    ISearchRole sr = rf.getSearchRole();

    sr.setValuesForKey(IUMPrincipal.DISPLAYNAME, new String[]{searchText});
    sr.setValuesForKey(IUMPrincipal.DISPLAYID, new String[]{searchText});
    sr.setValuesForKey(IUMPrincipal.DESCRIPTION, new String[]{searchText});
    sr.setSearchMethod(ISearchUMPrincipal.SEARCHMETHOD_OR);

    if (returningAttributes) {
      sr.setReturningAttributes(new String[]{IUMPrincipal.DISPLAYNAME, IUMPrincipal.DISPLAYID, IUMPrincipal.DESCRIPTION});
    }

    return sr;
  }

  public static String[] simpleRoleSearch(String searchText) {
    try {
      IRoleFactory rf = getRoleFactory();
      ISearchRole sr = getSimpleSearchRole(searchText, false);
      return rf.findRoles(sr, 0);
    }
    catch (Exception ex) {
            //$JL-EXC$      
      TRACE.errorT("Usermanagement failure while retrieving roles: " + LoggingFormatter.extractCallstack(ex));
      return null;
    }
  }

  public static String getPrincipalDescription(IUMPrincipal pr) {
    String description;
    if (pr.getType() == IUMPrincipal.IUSER) {
      description = pr.getDisplayName();
    }
    else {
      description = pr.getDescription();
    }
    if (description == null) {
      description = "";
    }

    return description;
  }

  public static String getIconNameForPrincipal(int principalType) {
    switch (principalType) {
      case IUMPrincipal.IUSER:
        return USER_ICON;
      case IUMPrincipal.IGROUP:
        return GROUP_ICON;
      case IUMPrincipal.IROLE:
        return ROLE_ICON;
    }

    return null;
  }
}
