/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.usermanagement;
import com.sap.tc.logging.Location;

import com.sapportals.portal.security.usermanagement.*;
import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.util.logging.LoggingFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/**
 * TBD: Description of the class.
 */
public final class SelectionUser {

  private String id;
  private String displayName;
  private int type;

  public SelectionUser(String id, String displayName, int type)
    throws WcmException {
    this.id = id;
    if (displayName != null) {
      this.displayName = displayName.trim();
    }
    else {
      this.displayName = displayName;
    }
    if ((type == SelectionUserManager.TYPE_USER) ||
      (type == SelectionUserManager.TYPE_ROLE) ||
      (type == SelectionUserManager.TYPE_GROUP) ||
      (type == SelectionUserManager.TYPE_UNCHECKED) ||
      (type == SelectionUserManager.TYPE_EMAIL)) {
      this.type = type;
    }
    else {
      throw new WcmException("illegal user type submitted");
    }
  }

  public SelectionUser(String id, int type)
    throws WcmException {
    try {
      this.id = id;
      switch (type) {
        case SelectionUserManager.TYPE_USER:
        {
          this.displayName = WPUMFactory.getUserFactory().getUser(id).getDisplayName();
          if ((this.displayName == null) || (this.displayName == "")) {
            this.displayName = WPUMFactory.getUserFactory().getUser(id).getDisplayId();
          }
          break;
        }
        case SelectionUserManager.TYPE_ROLE:
        {
          this.displayName = WPUMFactory.getRoleFactory().getRole(id).getDisplayName();
          if ((this.displayName == null) || (this.displayName == "")) {
            this.displayName = WPUMFactory.getRoleFactory().getRole(id).getDisplayId();
          }
          this.displayName = SelectionUserManager.DISPLAY_ROLE_OPEN + this.displayName + SelectionUserManager.DISPLAY_ROLE_CLOSE;
          break;
        }
        case SelectionUserManager.TYPE_GROUP:
        {
          this.displayName = WPUMFactory.getGroupFactory().getGroup(id).getDisplayName();
          if ((this.displayName == null) || (this.displayName == "")) {
            this.displayName = WPUMFactory.getGroupFactory().getGroup(id).getDisplayId();
          }
          this.displayName = SelectionUserManager.DISPLAY_GROUP_OPEN + this.displayName + SelectionUserManager.DISPLAY_GROUP_CLOSE;
          break;
        }
        case SelectionUserManager.TYPE_EMAIL:
        {
          this.displayName = id;
          break;
        }
        case SelectionUserManager.TYPE_UNCHECKED:
        {
          this.displayName = id;
          break;
        }
        default:
        {
          throw new WcmException("illegal user type submitted");
        }
      }
      this.type = type;
      if (this.displayName != null) {
        this.displayName = this.displayName.trim();
      }
    }
    catch (Exception e) {
      throw new WcmException(e);
    }
  }

  public String getId() {
    return this.id;
  }

  public String getDisplayName() {
    return this.displayName;
  }

  public int getType() {
    return this.type;
  }

  public boolean equals(Object o) {
    if (!(o instanceof SelectionUser)) {
      return false;
    }
    SelectionUser su = (SelectionUser)o;
    if ((su.getId().equals(this.getId())) &&
      (su.getType() == this.getType())) {
      return true;
    }
    return false;
  }

}
