/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

import java.util.*;

/**
 * An URL list implementation <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/uri/UriList.java#6
 *      $
 */
public class UriList implements IUriList {

  private LinkedList m_list = null;

  public UriList() {
    m_list = new LinkedList();
  }

  /**
   * Creates a uri list from a string. The string must be in an encoded format
   * where each uri is detached by <code>IUriList.SEPARATOR</code> .
   *
   * @param uris Exp.: "\wcm\a;\wcm\b;..."
   */
  public UriList(String uris) {
    this();
    this.addAll(uris);
  }

  public UriList(URI[] uris) {
    m_list = new LinkedList();
    for (int i = 0; i < uris.length; i++) {
      m_list.add(uris[i]);
    }
  }

  public UriList(UriList list) {
    m_list = new LinkedList(list.m_list);
  }

  public int size() {
    return m_list.size();
  }

  public boolean isEmpty() {
    return m_list.isEmpty();
  }

  public boolean add(URI uri) {
    return m_list.add(uri);
  }

  public boolean addAll(IUriList list) {
    return m_list.addAll(((UriList)list).m_list);
  }

  public boolean addAll(String uris) {
    StringTokenizer tokenizer = new StringTokenizer(uris, UriList.SEPARATOR, false);
    UriList uriList = new UriList();

    while (tokenizer.hasMoreElements()) {
      uriList.add(new URI(tokenizer.nextToken()));
    }

    return this.addAll(uriList);
  }

  public URI get(int index) {
    return (URI)m_list.get(index);
  }

  public URI set(int index, URI uri) {
    return (URI)m_list.set(index, uri);
  }

  public void add(int index, URI uri) {
    m_list.add(index, uri);
  }

  public void addLast(URI uri) {
    m_list.addLast(uri);
  }

  public void addFirst(URI uri) {
    m_list.addFirst(uri);
  }

  public URI remove(int index) {
    return (URI)m_list.remove(index);
  }

  public IUriIterator listIterator() {
    return new UriIterator(m_list.listIterator());
  }

  public IUriIterator listIterator(int index) {
    return new UriIterator(m_list.listIterator(index));
  }

  public String toString() {
    URI uri = null;
    String result = "";
    IUriIterator i = this.listIterator();

    while (i.hasNext()) {
      uri = (URI)i.next();
      result += uri.toString();
      if (i.hasNext()) {
        result += IUriList.SEPARATOR;
      }
    }

    return result;
  }
}

