/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

import com.sapportals.wcm.WcmObject;

/**
 * DO NOT USE this class except to create instances of URL objects to be used
 * for link creation. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author frank.renkes@sap.com
 * @author julian.reschke@greenbytes.de
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/uri/URL.java#13
 *      $
 */

public class URL extends WcmObject {

  private String url;
  private String uri;
  private String protocol;
  private String host;
  private String port;
  private String query;

  private final static String pdelim = "://";
  private final static String hdelim = ":";
  private final static String qdelim = "?";
  private final static String adelim = "/";

  /**
   * @deprecated as of NW04.
   */
  public URL() { }

  /**
   * @deprecated as of NW04. in general, use {@link UriFactory} to parse URIs -- to
   *      specifically create an instance of URL for usage with link creation
   *      methods, use {@link URL#getInstance(IUriReference)}, {@link
   *      URL#getInstance(RID)} or {@link URL#getInstance(String)}.
   */
  public URL(String url) {
    int idx = -1;

    this.url = url;

    idx = url.indexOf(pdelim);
    if (idx > -1) {
      this.protocol = url.substring(0, idx);
      url = url.substring(idx + pdelim.length(), url.length());
    }

    idx = url.indexOf(hdelim);
    if (idx > -1) {
      this.host = url.substring(0, idx);
      url = url.substring(idx + hdelim.length(), url.length());
    }

    idx = url.indexOf(adelim);
    if (idx > 0) {
      this.port = url.substring(0, idx);
      url = url.substring(idx, url.length());
    }

    idx = url.indexOf(qdelim);
    if (idx > 0) {
      this.query = url.substring(idx + qdelim.length(), url.length());
      this.uri = url.substring(0, idx);
    }
    else {
      this.uri = url;
    }
  }

  /**
   * Creates a "URL" object for usage as link target container.
   *
   * @param target string representation of a {@link RID} or a {@link
   *      IUriReference}.
   */
  public static URL getInstance(String target) {
    return new URL(target);
  }

  /**
   * Creates a "URL" object for usage as external link target container.
   *
   * @param uriref URI reference
   */
  public static URL getInstance(IUriReference uriref) {
    return new URL(uriref.toExternalForm());
  }

  /**
   * Creates a "URL" object for usage as internal link target container.
   *
   * @param rid RID
   */
  public static URL getInstance(RID rid) {
    return new URL(rid.toString());
  }

  /**
   * @return protocol
   * @deprecated as of NW04. Use {@link UriFactory} to parse URIs.
   */
  public String getProtocol() {
    return this.protocol;
  }

  /**
   * @deprecated as of NW04. Use {@link UriFactory} to parse URIs.
   */
  public String getHost() {
    return this.host;
  }

  /**
   * @deprecated as of NW04. Use {@link UriFactory} to parse URIs.
   */
  public String getPort() {
    return this.port;
  }

  /**
   * @deprecated as of NW04. Use {@link UriFactory} to parse URIs.
   */
  public String getQueryParameter() {
    return this.query;
  }

  /**
   * @deprecated as of NW04. Use {@link UriFactory} to parse URIs.
   */
  public URI getURI() {
    return new URI(this.uri);
  }
  
  public String toString() {
    return this.url;
  }
}
