/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

import java.util.HashSet;
import java.util.Set;

/**
 * A set of RID instances. <p>
 *
 * Copyright (c) SAP AG 2001-2003
 *
 * @author m.breitenfelder@sap.com
 * @version $Id: RidSet.java,v 1.6 2003/02/17 14:24:04 jre Exp $
 */
public class RidSet implements IRidSet {

  private final Set set;

  public RidSet(Set setOfRids) {
    this.set = new HashSet(setOfRids);
  }


  public RidSet(RidList ridList) {
    this.set = new HashSet(ridList.getContainedList());
  }

  public RidSet(int initialCapacity, float loadFactor) {
    this.set = new HashSet(initialCapacity, loadFactor);
  }

  public RidSet(int initialCapacity) {
    this.set = new HashSet(initialCapacity);
  }

  public RidSet() {
    this.set = new HashSet();
  }

  public RidSet(RidSet ridSet) {
    this.set = new HashSet(ridSet.set);
  }

  public RidSet(IRidList ridList) {
    if (ridList instanceof RidList) {
      this.set = new HashSet(((RidList)ridList).getContainedList());
    }
    else {
      this.set = new HashSet(ridList.size());
      for (IRidIterator i = ridList.listIterator(); i.hasNext(); ) {
        this.set.add(i.next());
      }
    }
  }


  public boolean isEmpty() {
    return this.set.isEmpty();
  }

  public int size() {
    return this.set.size();
  }

  public boolean add(RID rid) {
    return this.set.add(rid);
  }

  public boolean contains(RID rid) {
    return this.set.contains(rid);
  }

  public boolean remove(RID rid) {
    return this.set.remove(rid);
  }

  public IRidIterator iterator() {
    return new RidIterator(this.set.iterator());
  }

  public RID[] toArray() {
    return (RID[])this.set.toArray(new RID[this.set.size()]);
  }
}

