/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: RidList.java,v 1.3 2004/04/06 11:43:47 jre Exp $
 */

package com.sapportals.wcm.util.uri;

import java.util.*;

/**
 * An URL list implementation <p>
 *
 * Copyright (c) SAP AG 2001-2004
 *
 * @author m.breitenfelder@sap.com
 * @version $Id: RidList.java,v 1.3 2004/04/06 11:43:47 jre Exp $
 */
public class RidList implements IRidList {

  private final List list;

  public RidList() {
    this.list = new ArrayList();
  }

  /**
   * Creates a uri list from a string. The string must be in an encoded format
   * where each uri is detached by <code>IRidList.SEPARATOR</code> .
   */
  public RidList(String rids) {
    this();
    this.addAll(rids);
  }

  public RidList(RID[] rids) {
    this.list = new ArrayList(rids.length);
    for (int i = 0; i < rids.length; i++) {
      this.list.add(rids[i]);
    }
  }

  public RidList(RidList list) {
    this.list = new ArrayList(list.list);
  }

  public int size() {
    return this.list.size();
  }

  public boolean isEmpty() {
    return this.list.isEmpty();
  }

  public boolean add(RID rid) {
    return this.list.add(rid);
  }

  public boolean addAll(IRidList list) {
    return this.list.addAll(((RidList)list).list);
  }

  public boolean addAll(String rids) {
    StringTokenizer tokenizer = new StringTokenizer(rids, RidList.SEPARATOR, false);
    RidList ridList = new RidList();

    while (tokenizer.hasMoreElements()) {
      ridList.add(RID.getRID(tokenizer.nextToken()));
    }

    return this.addAll(ridList);
  }

  public RID get(int index) {
    return (RID)this.list.get(index);
  }

  public RID set(int index, RID rid) {
    return (RID)this.list.set(index, rid);
  }

  public void add(int index, RID rid) {
    this.list.add(index, rid);
  }

  public void addLast(RID rid) {
    this.list.add(rid);
  }

  public void addFirst(RID rid) {
    this.list.add(0, rid);
  }

  public RID remove(int index) {
    return (RID)this.list.remove(index);
  }

  public IRidIterator listIterator() {
    return new RidIterator(this.list.listIterator());
  }

  public IRidIterator listIterator(int index) {
    return new RidIterator(this.list.listIterator(index));
  }

  public String toString() {
    RID rid = null;
    String result = "";
    IRidIterator i = this.listIterator();

    while (i.hasNext()) {
      rid = i.next();
      result += rid.toString();
      if (i.hasNext()) {
        result += IRidList.SEPARATOR;
      }
    }

    return result;
  }

  protected List getContainedList() {
    return this.list;
  }


  public void sort(Comparator comp) {
    Collections.sort(this.list, comp);
  }
}

