/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

/**
 * This interface defines a list of <code>URI</code> instances <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/uri/IUriList.java#5
 *      $
 */
public interface IUriList {

  public final static String SEPARATOR = ";";

  public int size();

  public boolean isEmpty();

  public boolean add(URI event);

  public URI get(int index);

  public URI set(int index, URI event);

  public void add(int index, URI event);

  public boolean addAll(IUriList list);

  /**
   * Decodes uri list string and add them to the list. The string must have the
   * format as described in method <code> toString()</code> .
   *
   * @param uris Exp.: "\wcm\a;\wcm\b;..."
   * @return TBD: Description of the outgoing return value
   */
  public boolean addAll(String uris);

  public void addLast(URI event);

  public void addFirst(URI event);

  public URI remove(int index);

  public IUriIterator listIterator();

  public IUriIterator listIterator(int index);

  /**
   * Encodes uri list as uri strings detached by a SEPARATOR. Example:
   * "\wcm\a;\wcm\b;..."
   *
   * @return TBD: Description of the outgoing return value
   */
  public String toString();
}

