/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

/**
 * A <a href="http://www.ietf.org/rfc/rfc2396.txt">RFC2396</a> URI interface.
 * <pre>
 *     Uri ::= scheme ':' remainder
 * </pre> Copyright (c) SAP AG 2001-2002
 *
 * @author julian.reschke@greenbytes.de
 * @author stefan.eissing@greenbytes.de
 * @version $Id: IUri.java,v 1.4 2002/08/22 17:28:46 sei Exp $
 */

public interface IUri {

  /**
   * Get the scheme of this Uri (without ':').
   *
   * @return scheme of this Uri
   */
  public String getScheme();

  /**
   * Get the remainder of this Uri (part after scheme without ':').
   *
   * @return remainder of this Uri
   */
  public String getRemainder();

  /**
   * Resolve the uri reference in the context of this Uri.
   *
   * @param reference TBD: Description of the incoming method parameter
   * @return resolved reference as absolute uri without fragment identifier
   * @exception IllegalArgumentException Exception raised in failure situation
   */
  public IUri resolve(IUriReference reference)
    throws IllegalArgumentException;

  /**
   * Returns a string representation according to RFC 2396 of this uri.
   *
   * @return string in uri format
   */
  public String toExternalForm();
}
