/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.uri;

import java.util.Comparator;

/**
 * This interface defines a list of <code>RID</code> instances <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author Markus Breitenfelder
 * @version $Id:$
 */
public interface IRidList {

  public final static String SEPARATOR = ";";

  public int size();

  public boolean isEmpty();

  public boolean add(RID event);

  public RID get(int index);

  public RID set(int index, RID event);

  public void add(int index, RID event);

  public boolean addAll(IRidList list);

  /**
   * Decodes uri list string and add them to the list. The string must have the
   * format as described in method <code> toString()</code> .
   *
   * @param uris Exp.: "\wcm\a;\wcm\b;..."
   * @return TBD: Description of the outgoing return value
   */
  public boolean addAll(String uris);

  public void addLast(RID event);

  public void addFirst(RID event);

  public RID remove(int index);

  public IRidIterator listIterator();

  public IRidIterator listIterator(int index);

  /**
   * Encodes uri list as uri strings detached by a SEPARATOR. Example:
   * "\wcm\a;\wcm\b;..."
   *
   * @return TBD: Description of the outgoing return value
   */
  public String toString();

  public void sort(Comparator comp);
}

