/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.threads;

import java.util.*;

/**
 * Java semaphore implementation. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public class Semaphore implements ISemaphore {

  private boolean acquired = false;

  /**
   * Block the calling thread until semaphore could be acquired
   */
  public synchronized void acquire() {
    while (this.acquired) {
      try {
        wait();
      }
      catch (java.lang.InterruptedException ex) {
            //$JL-EXC$        
        com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(ex.getMessage());
      }
    }
    this.acquired = true;
  }

  /**
   * Try to acquire semaphore and block calling thread for a max. amount of time
   *
   * @param timeout Time-out value in seconds
   * @return True if the semaphore could be acquired, false if timed-out
   */
  public synchronized boolean acquire(int timeout) {
    long startTime = System.currentTimeMillis();
    long remaining = timeout;
    while (this.acquired) {
      try {
        wait(remaining);
      }
      catch (InterruptedException e) {
            //$JL-EXC$        
      }
      remaining = timeout - (System.currentTimeMillis() - startTime);
      if (remaining <= 0) {
        return false;
      }
    }
    this.acquired = true;
    return true;
  }

  /**
   * Release the semaphore
   */
  public synchronized void release() {
    this.acquired = false;
    notify();
  }
}
