/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.threads;

import java.util.*;

/**
 * A reader/writer lock implementation. Writers have higher priority which means
 * that readers are denied access if there are writer waiting to acquire access.
 * <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public class ReaderWriterLock implements IReaderWriterLock {

  private int numOfReaders = 0;

  private boolean writing = false;

  private int numOfWaitingWriters = 0;

  /**
   * Block the calling thread until the read lock could be acquired
   */
  public synchronized void acquireRead() {
    while (this.writing || this.numOfWaitingWriters > 0) {
      try {
        wait();
      }
      catch (java.lang.InterruptedException ex) {
            //$JL-EXC$        
        com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(ex.getMessage());
      }
    }
    this.numOfReaders++;
  }

  /**
   * Block the calling thread until the write lock could be acquired
   */
  public synchronized void acquireWrite() {
    this.numOfWaitingWriters++;
    while (this.numOfReaders > 0 || this.writing) {
      try {
        wait();
      }
      catch (java.lang.InterruptedException ex) {
            //$JL-EXC$        
        com.sap.tc.logging.Location.getLocation(this.getClass()).debugT(ex.getMessage());
      }
    }
    this.numOfWaitingWriters--;
    this.writing = true;
  }

  /**
   * Release the read lock
   */
  public synchronized void releaseRead() {
    this.numOfReaders--;
    if (this.numOfReaders == 0) {
      notifyAll();
    }
  }

  /**
   * Release the write lock
   */
  public synchronized void releaseWrite() {
    this.writing = false;
    notifyAll();
  }
}
