/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.threads;

/**
 * A semaphore interface. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public interface ISemaphore {

  /**
   * Block the calling thread until semaphore could be acquired
   */
  public void acquire();

  /**
   * Try to acquire semaphore and block calling thread for a max. amount of time
   *
   * @param timeout Time-out value in seconds
   * @return True if the semaphore could be acquired, false if timed-out
   */
  public boolean acquire(int timeout);

  /**
   * Release the semaphore
   */
  public void release();
}

