/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.threads;

/**
 * A reader/writer lock interface. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author m.breitenfelder@sapportals.com
 * @version $Id:$
 */
public interface IReaderWriterLock {

  /**
   * Block the calling thread until the read lock could be acquired
   */
  public void acquireRead();

  /**
   * Block the calling thread until the write lock could be acquired
   */
  public void acquireWrite();

  /**
   * Release the read lock
   */
  public void releaseRead();

  /**
   * Release the write lock
   */
  public void releaseWrite();
}

