/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.systemconfig;

import java.util.*;

/**
 * The (default) implementation for a <code>ISystemPrincipalListIterator</code>
 * . <br>
 *
 */
public class SystemPrincipalListIterator implements ISystemPrincipalListIterator {

  private final ISystemPrincipal[] principals;
  private int index;

  public SystemPrincipalListIterator(ISystemPrincipal[] principals) {
    this.principals = principals;
  }

  public boolean hasNext() {
    return this.index < this.principals.length;
  }

  public ISystemPrincipal next() {
    return this.principals[this.index++];
  }
}
