/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.systemconfig;

import com.sapportals.portal.security.usermanagement.*;

import com.sapportals.wcm.util.usermanagement.WPUMFactory;

import java.util.*;

/**
 * A prededefined principal with special rights within CM (e.g. a system user).
 * <br>
 *
 */
public interface ISystemPrincipal {
  /**
   * @return the principal from the usermanagement
   */
  public IUMPrincipal getPrincipal();

  /**
   * @return true iff the principal is allowed to break foreign locks on
   *      resources
   */
  public boolean isLockBreaker();
  
  /**
   * @return true iff the principal has all service acls
   */
  public boolean hasServiceAcls();

  /**
   * @return a set of strings containing the names of CM framework permissions
   *      which are granted to the principal on each resource
   */
  public Set getMappedPermissions();

  /**
   * @return true iff the principal is allowed to change permissions on each
   *      resource
   */
  public boolean canChangePermissions();

  /**
   * @return aclPermissions
   * @deprecated as of NW04.
   */
  public List getAclPermissions();

  /**
   * @return aclOwner
   * @deprecated as of NW04.
   */
  public boolean isAclOwner();

  /**
   * @return appLogViewer
   * @deprecated as of NW04.
   */
  public boolean isAppLogViewer();
}
