/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.string;
import java.io.FilterReader;

import java.io.IOException;
import java.io.Reader;

/**
 * Title: Replace encoded HTML tokens with their HTML character corespondents
 * Description: Copyright (c) SAP AG 2001-2002 Company: SAP AG
 *
 * @author corneliu.mitu@sap.com
 * @version 1.0
 */

public class ReplaceHTMLTokens extends FilterReader {
  String[] stringTokens = {"&copy;", "&amp;", "&gt;", "&lt;", "&nbsp;", "&#149;", ",", "\t", "\r\r"};
  String[] stringReplacements = {"", "&", ">", "<", " ", "", "", "", ""};

  public ReplaceHTMLTokens(Reader in) {
    super(in);
  }

  public int read(char[] buf, int from, int len)
    throws IOException {
    int numChars = 0;

    while (numChars == 0) {
      numChars = in.read(buf, from, len);
      if (numChars == -1) {
        return -1;
      }

      String lineString = new String(buf, from, numChars);
      for (int j = 0; j < stringTokens.length; j++) {
        lineString = replaceString(lineString,
          stringTokens[j], stringReplacements[j]);
      }
      lineString.getChars(0, lineString.length(), buf, from);
      numChars = lineString.length();
    }
    return numChars;
  }

  public int read()
    throws IOException {
    char[] buf = new char[1];
    int result = read(buf, 0, 1);
    if (result == -1) {
      return -1;
    }
    return (int)buf[0];
  }

  String replaceString(String src, String what, String with) {
    int pos = src.indexOf(what);
    if (pos == -1) {
      return src;
    }
    return src.substring(0, pos) + with + replaceString(src.substring(pos + what.length()), what, with);
  }
}
