/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.resource;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import com.sapportals.wcm.crt.CrtClassLoaderRegistry;

/**
 * A helper class to load resource bundles.
 *
 * @author Jens Kaiser
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/resource/ResourceBundles.java#11
 *      $
 */
public class ResourceBundles {
  private String m_baseName;

  private static com.sap.tc.logging.Location log = com.sap.tc.logging.Location.getLocation(com.sapportals.wcm.util.resource.ResourceBundles.class);

  private static HashMap m_bundles = new HashMap();
  private static HashMap m_failures = new HashMap();

  private ResourceBundles(String baseName) {
    m_baseName = baseName;
  }

  /**
   * Invalidates the cached resource bundles
   */
  public static void invalidate() {
    m_bundles.clear();
    m_failures.clear();
  }


  public String getString(String key, Locale locale, Object[] objs)
    throws MissingResourceException {
    String bundle = getBundle(m_baseName, locale).getString(key);

    if (objs != null) {
      MessageFormat msg = new MessageFormat(bundle);
      msg.setLocale(locale);
      StringBuffer replacement = new StringBuffer();
      msg.format(objs, replacement, null);
      bundle = replacement.toString();
    }
    return bundle;
  }


  public String getString(String key, Object[] objs)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), objs);
  }


  public String getString(String key, Object obj)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), new Object[]{obj});
  }


  public String getString(String key, Object obj1, Object obj2)
    throws MissingResourceException {
    return getString(key, Locale.getDefault(), new Object[]{obj1, obj2});
  }


  public String getString(String key, Locale locale)
    throws MissingResourceException {
    return getBundle(m_baseName, locale).getString(key);
  }


  public String getString(String key, Locale locale, Object obj)
    throws MissingResourceException {
    return getString(key, locale, new Object[]{obj});
  }


  public String getString(String key, Locale locale, Object obj1, Object obj2)
    throws MissingResourceException {
    return getString(key, locale, new Object[]{obj1, obj2});
  }


  public String getString(String key)
    throws MissingResourceException {
    return getString(key, Locale.getDefault());
  }


  public boolean exists(String key, Locale locale) {
    try {
      getString(key, locale);
    }
    catch (Exception ex) {
            //$JL-EXC$
      return false;
    }
    return true;
  }


  public boolean exists(String key) {
    try {
      this.getString(key);
    }
    catch (Exception ex) {
            //$JL-EXC$
      return false;
    }
    return true;
  }


  /**
   * Deprectated. This method has no effect.
   * @param cl
   */
  public static void registerClassLoader(ClassLoader cl) {
  }


  public static ResourceBundles getBundle(String baseName) {
    Locale locale = Locale.getDefault();
    return new ResourceBundles(baseName);
  }


  private HashMap getBundles(Locale locale) {
    if (m_bundles.containsKey(locale)) {
      return (HashMap)m_bundles.get(locale);
    }
    else {
      return null;
    }
  }


  private static HashMap getBundles(String baseName) {
    if (m_bundles.containsKey(baseName)) {
      return (HashMap)(m_bundles.get(baseName));
    }
    else {
      return null;
    }
  }


  private static void setBundles(String baseName, HashMap bundles) {
    m_bundles.put(baseName, bundles);
  }


  private static ResourceBundle getBundle(String baseName, Locale locale) {
		MissingResourceException x = null;
		
    HashMap baseMap = (HashMap)m_failures.get(baseName);
    if( baseMap != null ) {
    	x = (MissingResourceException)baseMap.get(locale);
    }

    if (x == null) {
      try {
        return ResourceBundle.getBundle(baseName, locale, CrtClassLoaderRegistry.getClassLoader());
      }
      catch (MissingResourceException mrx) {
      	if( baseMap == null ) {
      		baseMap = new HashMap();
    			m_failures.put(baseName, baseMap);
      	}
   			baseMap.put(locale, mrx);
        throw mrx;
      }
    }
    throw x;
  }
}
