/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex.re;

/**
 * Encapsulates String
 */
public final class StringCharacterIterator implements CharacterIterator {
  /**
   * encapsulated
   */
  private final String src;

  /**
   * @param src - encapsulated String
   */
  public StringCharacterIterator(String src) {
    this.src = src;
  }

  /**
   * @param offset TBD: Description of the incoming method parameter
   * @param length TBD: Description of the incoming method parameter
   * @return a substring
   */
  public String substring(int offset, int length) {
    return src.substring(offset, length);
  }

  /**
   * @param offset TBD: Description of the incoming method parameter
   * @return a substring
   */
  public String substring(int offset) {
    return src.substring(offset);
  }

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return a character at the specified position.
   */
  public char charAt(int pos) {
    return src.charAt(pos);
  }

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return <tt>true</tt> iff if the specified index is after the end of the
   *      character stream
   */
  public boolean isEnd(int pos) {
    return (pos >= src.length());
  }
}
