/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex.re;

/**
 * This is a class that contains utility helper methods for this package.
 */
public class REUtil {
  /**
   * complex:
   */
  private final static String complexPrefix = "complex:";

  /**
   * Creates a regular expression, permitting simple or complex syntax
   *
   * @param expression The expression, beginning with a prefix if it's complex
   *      or having no prefix if it's simple
   * @param matchFlags Matching style flags
   * @return The regular expression object
   * @exception RESyntaxException thrown in case of error
   */
  public static RE createRE(String expression, int matchFlags)
    throws RESyntaxException {
    if (expression.startsWith(complexPrefix)) {
      return new RE(expression.substring(complexPrefix.length()), matchFlags);
    }
    return new RE(RE.simplePatternToFullRegularExpression(expression), matchFlags);
  }

  /**
   * Creates a regular expression, permitting simple or complex syntax
   *
   * @param expression The expression, beginning with a prefix if it's complex
   *      or having no prefix if it's simple
   * @return The regular expression object
   * @exception RESyntaxException thrown in case of error
   */
  public static RE createRE(String expression)
    throws RESyntaxException {
    return createRE(expression, RE.MATCH_NORMAL);
  }
}
