/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex.re;

/**
 * Encapsulates different types of character sources - String, InputStream, ...
 * Defines a set of common methods
 */
public interface CharacterIterator {
  /**
   * @param offset TBD: Description of the incoming method parameter
   * @param length TBD: Description of the incoming method parameter
   * @return a substring
   */
  String substring(int offset, int length);

  /**
   * @param offset TBD: Description of the incoming method parameter
   * @return a substring
   */
  String substring(int offset);

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return a character at the specified position.
   */
  char charAt(int pos);

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return <tt>true</tt> iff if the specified index is after the end of the
   *      character stream
   */
  boolean isEnd(int pos);
}
