/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex.re;

/**
 * Encapsulates String
 */
public final class CharacterArrayCharacterIterator implements CharacterIterator {
  /**
   * encapsulated
   */
  private final char[] src;
  /**
   * offset in the char array
   */
  private final int off;
  /**
   * used portion of the array
   */
  private final int len;

  /**
   * @param src - encapsulated String
   * @param off TBD: Description of the incoming method parameter
   * @param len TBD: Description of the incoming method parameter
   */
  public CharacterArrayCharacterIterator(char[] src, int off, int len) {
    this.src = src;
    this.off = off;
    this.len = len;
  }

  /**
   * @param offset TBD: Description of the incoming method parameter
   * @param length TBD: Description of the incoming method parameter
   * @return a substring
   */
  public String substring(int offset, int length) {
    return new String(src, off + offset, length);
  }

  /**
   * @param offset TBD: Description of the incoming method parameter
   * @return a substring
   */
  public String substring(int offset) {
    return new String(src, off + offset, len);
  }

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return a character at the specified position.
   */
  public char charAt(int pos) {
    return src[off + pos];
  }

  /**
   * @param pos TBD: Description of the incoming method parameter
   * @return <tt>true</tt> iff if the specified index is after the end of the
   *      character stream
   */
  public boolean isEnd(int pos) {
    return (pos >= len);
  }
}
