/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex;

//import org.apache.regexp.RE;
import com.sapportals.wcm.util.regex.re.RE;

/**
 * Provides a matcher object for a given regular expression pattern.
 */
public class Matcher {
  private Pattern m_pattern = null;
  private String m_input = null;

  public Matcher(Pattern pattern, String input) {
    m_pattern = pattern;
    m_input = input;
  }

  /**
   * Implements a non-terminal append-and-replace step.
   *
   * @param sb TBD: Description of the incoming method parameter
   * @param replacement TBD: Description of the incoming method parameter
   */
  public void appendReplacement(StringBuffer sb, String replacement) {
    throw new UnsupportedOperationException();
  }

  /**
   * Implements a terminal append-and-replace step.
   *
   * @param sb TBD: Description of the incoming method parameter
   */
  public void appendTail(StringBuffer sb) {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the end index of the previous match.
   *
   * @return TBD: Description of the outgoing return value
   */
  public int end() {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the end index of the subsequence captured by the given group during
   * the previous match operation.
   *
   * @param group TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public int end(int group) {
    return m_pattern.getExpression().getParenEnd(group);
  }

  /**
   * Attempts to find the next subsequence of the input sequence that matches
   * the pattern.
   *
   * @return TBD: Description of the outgoing return value
   */
  public boolean find() {
    throw new UnsupportedOperationException();
  }

  /**
   * Resets this matcher and then attempts to find the next subsequence of the
   * input sequence that matches the pattern, starting at the specified index.
   *
   * @param start TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  boolean find(int start) {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the input subsequence matched by the previous match.
   *
   * @return TBD: Description of the outgoing return value
   */
  public String group() {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the input subsequence captured by the given group during the
   * previous match operation.
   *
   * @param group TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public String group(int group) {
    return m_pattern.getExpression().getParen(group);
  }

  /**
   * Returns the number of capturing groups in this matcher's pattern.
   *
   * @return TBD: Description of the outgoing return value
   */
  public int groupCount() {
    return m_pattern.getExpression().getParenCount();
  }

  /**
   * Attempts to match the input sequence, starting at the beginning, against
   * the pattern.
   *
   * @return TBD: Description of the outgoing return value
   */
  public boolean lookingAt() {
    throw new UnsupportedOperationException();
  }

  /**
   * Attempts to match the entire input sequence against the pattern.
   *
   * @return TBD: Description of the outgoing return value
   */
  public boolean matches() {
    return m_pattern.getExpression().match(m_input);
  }

  /**
   * Returns the pattern that is interpreted by this matcher.
   *
   * @return TBD: Description of the outgoing return value
   */
  public Pattern pattern() {
    return m_pattern;
  }

  /**
   * Replaces every subsequence of the input sequence that matches the pattern
   * with the given replacement string.
   *
   * @param replacement TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public String replaceAll(String replacement) {
    throw new UnsupportedOperationException();
  }

  /**
   * Resets this matcher.
   */
  public void reset() {
    throw new UnsupportedOperationException();
  }

  /**
   * Resets this matcher with a new input sequence.
   *
   * @param input TBD: Description of the incoming method parameter
   */
  public void reset(CharSequence input) {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the start index of the previous match.
   *
   * @return TBD: Description of the outgoing return value
   */
  public int start() {
    throw new UnsupportedOperationException();
  }

  /**
   * Returns the start index of the subsequence captured by the given group
   * during the previous match operation.}
   *
   * @param group TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  public int start(int group) {
    return m_pattern.getExpression().getParenStart(group);
  }
}
