/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex;

/**
 * Provides an interface for access to strings as sequences of characters.
 */
public class CharSequenceImpl implements CharSequence {
  private String m_s;

  public CharSequenceImpl(String s) {
    m_s = s;
  }

  public char charAt(int index) {
    return m_s.charAt(index);
  }

  public int length() {
    return m_s.length();
  }

  public CharSequence subSequence(int start, int end) {
    return new CharSequenceImpl(m_s.substring(start, end));
  }

  public String toString() {
    return m_s;
  }
}
