/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.regex;

/**
 * Implementation of access to strings as sequences of characters.
 */
public interface CharSequence {
  /**
   * Returns the character at the specified index.
   *
   * @param index TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  char charAt(int index);

  /**
   * Returns the length of this character sequence.
   *
   * @return TBD: Description of the outgoing return value
   */
  int length();

  /**
   * Returns a new character sequence that is a subsequence of this sequence.
   *
   * @param start TBD: Description of the incoming method parameter
   * @param end TBD: Description of the incoming method parameter
   * @return TBD: Description of the outgoing return value
   */
  CharSequence subSequence(int start, int end);

  /**
   * Returns a string containing the characters in this sequence in the same
   * order as this sequence.
   *
   * @return TBD: Description of the outgoing return value
   */
  String toString();
}
