/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.name;

/**
 * Generic interface for the representation of namespace-qualified names. <p>
 *
 * Copyright (c) SAP AG 2001-2002
 *
 * @author julian.reschke@greenbytes.de
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/name/IName.java#6
 *      $
 */

public interface IName {

  /**
   * Returns the namespace URI (a missing namespace is mapped to an empty
   * string).
   *
   * @return namespace
   */
  public String getNamespace();

  /**
   * Returns the namespace URI (a missing namespace is mapped to <code>null
   * </code>). Use this function if the value is going to be passed to a XML DOM
   * level 2 method.
   *
   * @return namespaceOrNull
   */
  public String getNamespaceOrNull();

  /**
   * Returns the local name.
   *
   * @return name
   */
  public String getName();

}
