/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.mmparser;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;

/**
 * Mime Multipart Parser.
 *
 * @author SAP AG
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/mmparser/MimeMultipartParser.java#6
 *      $ Copyright (c) SAP AG 2001-2002
 */
public class MimeMultipartParser {
  /**
   * <Please write something about this attribute>
   *
   *
   */
  private String m_contentType;

  /**
   * <Please write something about this attribute>
   *
   *
   */
  private int m_contentLength;

  /**
   * <Please write something about this attribute>
   *
   *
   */
  private String m_boundary;

  /**
   * <Please write something about this attribute>
   *
   *
   */
  private MMInputStream m_inputStream;

  /**
   * <Please write something about this attribute>
   *
   *
   *
   * @label HTTP header
   */
  private HeaderFields m_headers;

  /**
   * <Please write something about this attribute>
   *
   *
   *
   * @supplierCardinality 0..1
   * @clientCardinality 1
   * @supplierRole last part
   */
  private FilePart m_lastFilePart;
  // Buffer for reading from input stream


  /**
   * <Please write something about this attribute>
   *
   *
   */
  private byte[] m_buf = new byte[8 * 1024];

  /**
   * Create parser for a servlet request
   *
   * @param req The HttpServletResponse object
   * @exception IOException
   */
  public MimeMultipartParser(HttpServletRequest req)
    throws IOException {
    m_headers = new HeaderFields();
    String name;
    String value;
    Enumeration en = req.getHeaderNames();
    while (en.hasMoreElements()) {
      name = (String)en.nextElement();
      value = req.getHeader(name);
      m_headers.setHeaderField(name, value);
    }
    m_contentType = m_headers.getHeaderField("content-type");
    if (m_contentType == null) {
      throw new IOException("Content type is not multipart/form-data");
    }
    if (!m_contentType.toLowerCase().startsWith("multipart/form-data")) {
      throw new IOException("Content type is not multipart/form-data");
    }
    m_contentLength = Integer.parseInt(m_headers.getHeaderField("content-length"));
    m_inputStream = new MMInputStream(req.getInputStream());
    init();
  }


  /**
   * Create parser for a HttpURLConnection
   *
   * @param con The HttpURLConnection object
   * @exception IOException
   */
  public MimeMultipartParser(HttpURLConnection con)
    throws IOException {
    m_headers = new HeaderFields();
    String name;
    String value;
    int i = 1;
    while ((name = con.getHeaderFieldKey(i)) != null) {
      value = con.getHeaderField(i);
      m_headers.setHeaderField(name, value);
      i++;
    }
    m_contentType = m_headers.getHeaderField("content-type");
    if (m_contentType == null) {
      throw new IOException("Content type is not multipart/form-data");
    }
    if (!m_contentType.toLowerCase().startsWith("multipart/form-data")) {
      throw new IOException("Content type is not multipart/form-data");
    }
    m_contentLength = Integer.parseInt(m_headers.getHeaderField("content-length"));
    m_inputStream = new MMInputStream(con.getInputStream());
    init();
  }

  /**
   * Parse the content type and check the data
   *
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  private void init()
    throws IOException {
    // Extract the boundary string
    m_boundary = findBoundary(m_headers.getHeaderField("content-type"));
    if (m_boundary == null) {
      throw new IOException("No mime-multipart bondary was found in the content type.");
    }
    // Verify that the boundary is in the first line
    String line = nextLine();
    if (line == null) {
      throw new IOException("Invalid multipart form data received.");
    }
    if (!line.startsWith(m_boundary)) {
      throw new IOException("Invalid multipart form data received.");
    }
  }

  /**
   * Read the next part from the stream. The submitted form can contain files or
   * parameters (name/value pairs).
   *
   * @return either a <code>FilePart</code> , a <code>ParamPart</code> or null
   *      if there are no more parts to read.
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  public AbstractPart nextPart()
    throws IOException {
    // Close the stream of the last MMPart if it has not been read
    if (m_lastFilePart != null) {
      m_lastFilePart.getInputStream().close();
      m_lastFilePart = null;
    }
    // Read all header lines
    HeaderFields header = new HeaderFields();
    String line;
    String hname;
    String hvalue;
    int pos;
    while (true) {
      line = nextLine();
      if (line == null) {
        break;
      }
      if (line.equals("")) {
        break;
      }
      else {
        pos = line.indexOf(":");
        if (pos > -1) {
          hname = line.substring(0, pos);
          hvalue = line.substring(pos + 1).trim();
          header.setHeaderField(hname, hvalue);
        }
      }
    }
    // No more parts
    if (header.size() == 0) {
      return null;
    }
    // Parse content-disposition:
    // content-disposition: form-data; name="field1"; filename="file1.txt"
    int pos2;
    String name = null;
    String filename = null;
    String dispinfo = header.getHeaderField("content-disposition");
    if (dispinfo != null) {
      pos = dispinfo.indexOf("name=\"");
      pos2 = dispinfo.lastIndexOf(";");
      if (pos == -1) {
        throw new IOException("Malformed content-disposition in multipart header: " + dispinfo);
      }
      if (pos2 < pos) {
        name = dispinfo.substring(pos + 6, dispinfo.length() - 1);
      }
      else {
        name = dispinfo.substring(pos + 6, pos2 - 1);
      }
      pos = dispinfo.indexOf("filename=\"", pos2);
      if (pos > -1) {
        filename = dispinfo.substring(pos + 10, dispinfo.length() - 1);
        pos = filename.lastIndexOf("/");
        if (pos == -1) {
          pos = filename.lastIndexOf("\\");
        }
        if (pos > -1) {
          filename = filename.substring(pos);
        }
      }
    }
    else {
      filename = header.getHeaderField("x-compid");
      if (filename == null) {
        throw new IOException("Multipart header contains no content-diposition or x-compid.");
      }
      name = "sap_contentserver_component";
    }
    // Content type
    String contentType = header.getHeaderField("content-type");
    if (contentType == null) {
      header.setHeaderField("content-type", "text/plain");// default
    }
    if (filename == null) {
      // Found a parameter part
      return new ParamPart(name, m_inputStream, m_boundary);
    }
    else {
      // Found a file part
      if (filename.equals("")) {
        filename = null;
      }
      m_lastFilePart = new FilePart(name, m_inputStream, m_boundary, filename, header);
      return m_lastFilePart;
    }
  }

  /**
   * Finds the boundary string in a line.
   *
   * @param line <Please write something about this parameter>
   *
   *
   * @return the boundary string.
   */
  private String findBoundary(String line) {
    int index = line.lastIndexOf("boundary=");
    if (index == -1) {
      return null;
    }
    String boundary = "--" + line.substring(index + 9);// "--" is important!
    return boundary;
  }

  /**
   * Read the next line of input.
   *
   * @return a String containing the next line of input from the stream, or null
   *      to indicate the end of the stream.
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  private String nextLine()
    throws IOException {
    StringBuffer sb = new StringBuffer();
    int bytesRead = m_inputStream.readLine(m_buf, 0, m_buf.length);
    if (bytesRead != -1) {
      sb.append(
        new String(m_buf, 0, bytesRead, "ISO-8859-1"));
    }
    // Assume that HTTP header lines always fit in buffer
    if (bytesRead == m_buf.length) {
      throw new IOException("Malformed mime multipart header (buffer overrun).");
    }
    // End of stream ?
    if (sb.length() == 0) {
      return null;
    }
    // cut the "\r\n"
    sb.setLength(sb.length() - 2);
    return sb.toString();
  }
}

