/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id$
 */

package com.sapportals.wcm.util.mmparser;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * A <code>FilePart</code> is an upload part which represents a <code>INPUT
 * TYPE="file"</code> form parameter.
 *
 * @author Markus Breitenfelder
 * @version $Id: //javabas/com.sapportals.wcm/dev/src/java/util/api/com/sapportals/wcm/util/mmparser/FilePart.java#6
 *      $ Copyright (c) SAP AG 2001-2002
 */
public class FilePart extends AbstractPart {

  /**
   * file system name of the file
   */
  private String fileName;

  /**
   * input stream containing file data
   */
  private PartInputStream partInput;

  /**
   * <Please write something about this attribute>
   *
   *
   *
   * @label Mime part header
   */
  private HeaderFields m_header;

  /**
   * Construct a file part; this is called by the parser.
   *
   * @param name the name of the parameter.
   * @param in the servlet input stream to read the file from.
   * @param boundary the MIME boundary that delimits the end of file.
   * @param fileName the file system name of the file provided in the MIME
   *      header.
   * @param header <Please write something about this parameter>
   *
   *
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  FilePart(String name, MMInputStream in, String boundary, String fileName, HeaderFields header)
    throws IOException {
    super(name);
    m_header = header;
    this.fileName = fileName;
    partInput = new PartInputStream(in, boundary);
  }

  /**
   * Returns the name that the file was stored with on the remote system, or
   * <code>null</code> if the user didn't enter a file to be uploaded. Note:
   * this is not the same as the name of the form parameter used to transmit the
   * file; that is available from the <code>getName</code> method.
   *
   * @return name of file uploaded or <code>null</code> .
   */
  public String getFileName() {
    return fileName;
  }

  /**
   * <Please write something about this operation>
   *
   *
   *
   * @return <Please write something about the return value>
   *
   *
   */
  public HeaderFields getHeader() {
    return (HeaderFields)m_header.clone();
  }

  /**
   * <Please write something about this operation>
   *
   *
   *
   * @param header <Please write something about this parameter>
   *
   *
   */
  public void setHeader(HeaderFields header) {
    m_header = header;
  }

  /**
   * Returns an input stream which contains the contents of the file supplied.
   * If the user didn't enter a file to upload there will be <code>0</code>
   * bytes in the input stream.
   *
   * @return an input stream containing contents of file.
   */
  public InputStream getInputStream() {
    return partInput;
  }

  /**
   * Write this file part to a file or directory. If the user supplied a file,
   * we write it to that file, and if they supplied a directory, we write it to
   * that directory with the filename that accompanied it. If this part doesn't
   * contain a file this method does nothing.
   *
   * @param fileOrDirectory <Please write something about this parameter>
   *
   *
   * @return number of bytes written
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  public long writeTo(File fileOrDirectory)
    throws IOException {
    long written = 0;

    OutputStream fileOut = null;
    try {
      // Only do something if this part contains a file
      if (fileName != null) {
        // Check if user supplied directory
        File file;
        if (fileOrDirectory.isDirectory()) {
          // Write it to that dir the user supplied,
          // with the filename it arrived with
          file = new File(fileOrDirectory, fileName);
        }
        else {
          // Write it to the file the user supplied,
          // ignoring the filename it arrived with
          file = fileOrDirectory;
        }
        fileOut = new BufferedOutputStream(
          new FileOutputStream(file));
        written = write(fileOut);
      }
    }
    finally {
      if (fileOut != null) {
        fileOut.close();
      }
    }
    return written;
  }

  /**
   * Write this file part to the given output stream. If this part doesn't
   * contain a file this method does nothing.
   *
   * @param out <Please write something about this parameter>
   *
   *
   * @return number of bytes written.
   * @exception IOException <Please write something about why this exception
   *      would be thrown>
   *
   *
   */
  public long writeTo(OutputStream out)
    throws IOException {
    long size = 0;
    // Only do something if this part contains a file
    if (fileName != null) {
      // Write it out
      write(out);
    }
    return size;
  }

  /**
   * Returns <code>true</code> to indicate this part is a file.
   *
   * @return true.
   */
  public boolean isFile() {
    return true;
  }

  /**
   * Internal method to write this file part; doesn't check to see if it has
   * contents first.
   *
   * @param out <Please write something about this parameter>
   *
   *
   * @return number of bytes written.
   * @exception IOException if an input or output exception has occurred.
   */
  protected long write(OutputStream out)
    throws IOException {
    // decode macbinary if this was sent
    //if (contentType.equals("application/x-macbinary")) {
    //  out = new MacBinaryDecoderOutputStream(out);
    //}
    long size = 0;
    int read;
    byte[] buf = new byte[8 * 1024];
    while ((read = partInput.read(buf)) != -1) {
      out.write(buf, 0, read);
      size += read;
    }
    return size;
  }

}

